/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\r\u001a\u00020\f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "<init>", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;"})
public final class WasmJsCallChecker
implements CallChecker {
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public WasmJsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (context.isAnnotationContext() || !JsCallChecker.Companion.isJsCall(resolvedCall2)) {
            return;
        }
        DeclarationDescriptor containingDeclaration = context.getScope().getOwnerDescriptor();
        if (!(containingDeclaration instanceof FunctionDescriptor) && !(containingDeclaration instanceof PropertyDescriptor) || !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration)) {
            context.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
        } else {
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)containingDeclaration;
            if (callableMemberDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)containingDeclaration;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (!JsCodeUtilsKt.hasValidJsCodeBody(functionDescriptor, bindingContext)) {
                    context.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
                } else {
                    if (((FunctionDescriptor)containingDeclaration).isSuspend()) {
                        context.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "suspend function"));
                    }
                    if (((FunctionDescriptor)containingDeclaration).isInline()) {
                        context.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "inline function"));
                    }
                    if (((FunctionDescriptor)containingDeclaration).getExtensionReceiverParameter() != null) {
                        context.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "function with extension receiver"));
                    }
                    for (ValueParameterDescriptor parameter : ((FunctionDescriptor)containingDeclaration).getValueParameters()) {
                        String string2 = parameter.getName().getIdentifierOrNullIfSpecial();
                        if (string2 != null ? IdentifierPolicyKt.isValidES5Identifier(string2) : false) continue;
                        BindingTrace bindingTrace = context.getTrace();
                        Intrinsics.checkNotNull(parameter);
                        PsiElement psiElement = SourceLocationUtilsKt.findPsi(parameter);
                        if (psiElement == null) {
                            psiElement = reportOn;
                        }
                        bindingTrace.report(ErrorsWasm.JSCODE_INVALID_PARAMETER_NAME.on(psiElement));
                    }
                }
            } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)containingDeclaration;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (!JsCodeUtilsKt.hasValidJsCodeBody(propertyDescriptor, bindingContext)) {
                    context.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
                }
            }
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        KtElement expression = ktElement;
        if (!(expression instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list = arguments2;
        if (list == null || (list = CollectionsKt.firstOrNull(list)) == null || (list = ((KtValueArgument)((Object)list)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument = list;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.getTrace(), "WasmJsCallChecker");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)argument), trace, TypeUtils.NO_EXPECTED_TYPE);
        String code = JsCallChecker.Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument))));
            return;
        }
        trace.commit();
    }
}

