/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex;

import java.util.NoSuchElementException;
import org.sonarsource.analyzer.commons.regex.CharacterBuffer;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class RegexLexer {
    public static final int EOF = -1;
    private final RegexSource source;
    private final CharacterParser characters;
    private CharacterBuffer buffer = new CharacterBuffer(2);
    private boolean freeSpacingMode = false;
    private boolean escaped = false;
    private boolean hasComments = false;
    private boolean quotingMode = false;

    public RegexLexer(RegexSource source, CharacterParser characters) {
        this.source = source;
        this.characters = characters;
        this.moveNext();
    }

    public boolean getFreeSpacingMode() {
        return this.freeSpacingMode;
    }

    public void setFreeSpacingMode(boolean freeSpacingMode) {
        if (this.freeSpacingMode != freeSpacingMode) {
            this.freeSpacingMode = freeSpacingMode;
            this.emptyBuffer();
        }
    }

    public void moveNext(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.moveNext();
        }
    }

    public void moveNext() {
        if (!this.buffer.isEmpty()) {
            this.buffer.removeFirst();
        }
        if (this.buffer.isEmpty()) {
            this.fillBuffer(1);
        }
    }

    public SourceCharacter getCurrent() {
        this.fillBuffer(1);
        if (this.buffer.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buffer.get(0);
    }

    public int getCurrentChar() {
        if (this.isNotAtEnd()) {
            return this.getCurrent().getCharacter();
        }
        return -1;
    }

    public IndexRange getCurrentIndexRange() {
        if (this.isNotAtEnd()) {
            return this.getCurrent().getRange();
        }
        return new IndexRange(this.source.length(), this.source.length() + 1);
    }

    public int getCurrentStartIndex() {
        if (this.isAtEnd()) {
            return this.source.length();
        }
        return this.getCurrent().getRange().getBeginningOffset();
    }

    public boolean isAtEnd() {
        this.fillBuffer(1);
        return this.buffer.isEmpty() && this.characters.isAtEnd();
    }

    public boolean isNotAtEnd() {
        return !this.isAtEnd();
    }

    public boolean isInQuotingMode() {
        return this.quotingMode;
    }

    public boolean currentIs(char ch) {
        return this.getCurrentChar() == ch;
    }

    public boolean currentIs(String str) {
        this.fillBuffer(str.length());
        if (this.buffer.size() < str.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.buffer.get(i).getCharacter() == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int lookAhead(int offset) {
        this.fillBuffer(offset + 1);
        if (this.buffer.size() <= offset) {
            return -1;
        }
        return this.buffer.get(offset).getCharacter();
    }

    public boolean hasComments() {
        return this.hasComments;
    }

    private void emptyBuffer() {
        if (!this.buffer.isEmpty()) {
            this.characters.resetTo(this.buffer.get(0).getRange().getBeginningOffset());
            this.buffer = new CharacterBuffer(2);
        }
    }

    private void fillBuffer(int size) {
        this.skipCommentsAndWhiteSpace();
        while (this.buffer.size() < size && this.characters.isNotAtEnd()) {
            SourceCharacter sourceCharacter = this.characters.getCurrent();
            this.characters.moveNext();
            if (!this.escaped && sourceCharacter.getCharacter() == '\\') {
                if (this.readQuotingDelimiter()) {
                    this.skipCommentsAndWhiteSpace();
                    continue;
                }
                this.escaped = !this.quotingMode;
            } else {
                this.escaped = false;
            }
            this.buffer.add(sourceCharacter);
            this.skipCommentsAndWhiteSpace();
        }
    }

    private boolean readQuotingDelimiter() {
        if (this.characters.isAtEnd()) {
            return false;
        }
        char ch = this.characters.getCurrent().getCharacter();
        if (!this.quotingMode && ch == 'Q' || this.quotingMode && ch == 'E') {
            this.quotingMode = !this.quotingMode;
            this.characters.moveNext();
            return true;
        }
        return false;
    }

    private void skipCommentsAndWhiteSpace() {
        if (!this.freeSpacingMode) {
            return;
        }
        while (this.characters.isNotAtEnd() && this.isSkippable(this.characters.getCurrent().getCharacter())) {
            if (this.characters.getCurrent().getCharacter() == '#') {
                this.hasComments = true;
                while (this.characters.isNotAtEnd() && this.characters.getCurrent().getCharacter() != '\n') {
                    this.characters.moveNext();
                }
                continue;
            }
            this.characters.moveNext();
        }
    }

    private boolean isSkippable(char ch) {
        return !this.quotingMode && !this.escaped && (Character.isWhitespace(ch) || ch == '#');
    }
}

