/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Optional;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.EndOfCapturingGroupState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

public class CapturingGroupTree
extends GroupTree {
    private final String name;
    private final int groupNumber;

    public CapturingGroupTree(RegexSource source, IndexRange range, String name, int groupNumber, RegexTree element, FlagSet activeFlags) {
        super(source, RegexTree.Kind.CAPTURING_GROUP, element, range, activeFlags);
        this.name = name;
        this.groupNumber = groupNumber;
        element.setContinuation(new EndOfCapturingGroupState(this, activeFlags));
    }

    @Override
    public void setContinuation(AutomatonState continuation2) {
        this.setContinuation(continuation2, null);
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitCapturingGroup(this);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    @Override
    public RegexTree getElement() {
        return this.element;
    }
}

