/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexToken;

public class CurlyBraceQuantifier
extends Quantifier {
    private final RegexToken minimumRepetitionsToken;
    private final int minimumRepetitions;
    private final RegexToken commaToken;
    private final RegexToken maximumRepetitionsToken;
    private final Integer maximumRepetitions;

    public CurlyBraceQuantifier(RegexSource source, IndexRange range, Quantifier.Modifier modifier, RegexToken minimumRepetitionsToken, RegexToken commaToken, RegexToken maximumRepetitionsToken) {
        super(source, range, modifier);
        this.minimumRepetitionsToken = minimumRepetitionsToken;
        this.minimumRepetitions = minimumRepetitionsToken == null ? 0 : Integer.parseInt(minimumRepetitionsToken.getText());
        this.commaToken = commaToken;
        this.maximumRepetitionsToken = maximumRepetitionsToken;
        this.maximumRepetitions = maximumRepetitionsToken == null ? null : Integer.valueOf(Integer.parseInt(maximumRepetitionsToken.getText()));
    }

    @Override
    public int getMinimumRepetitions() {
        return this.minimumRepetitions;
    }

    @Override
    public Integer getMaximumRepetitions() {
        if (this.commaToken == null) {
            return this.minimumRepetitions;
        }
        return this.maximumRepetitions;
    }

    public RegexToken getMinimumRepetitionsToken() {
        return this.minimumRepetitionsToken;
    }

    public RegexToken getCommaToken() {
        return this.commaToken;
    }

    public RegexToken getMaximumRepetitionsToken() {
        return this.maximumRepetitionsToken;
    }

    @Override
    public boolean isFixed() {
        return this.commaToken == null;
    }
}

