/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Arrays;
import java.util.List;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.EndOfLookaroundState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.NegationState;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;
import org.sonarsource.analyzer.commons.regex.ast.StartOfLookBehindState;

public class LookAroundTree
extends GroupTree {
    private final Polarity polarity;
    private final Direction direction;
    private AutomatonState inner;

    public LookAroundTree(RegexSource source, IndexRange range, Polarity polarity, Direction direction, RegexTree element, FlagSet activeFlags) {
        super(source, RegexTree.Kind.LOOK_AROUND, element, range, activeFlags);
        this.polarity = polarity;
        this.direction = direction;
        element.setContinuation(new EndOfLookaroundState(this, activeFlags));
        AutomatonState automatonState = this.inner = polarity == Polarity.NEGATIVE ? new NegationState(element, activeFlags) : element;
        if (direction == Direction.BEHIND) {
            this.inner = new StartOfLookBehindState(this.inner, activeFlags);
        }
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitLookAround(this);
    }

    @Override
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    @Override
    public RegexTree getElement() {
        return this.element;
    }

    @Override
    public void setContinuation(AutomatonState continuation2) {
        this.setContinuation(continuation2, null);
    }

    @Override
    public List<AutomatonState> successors() {
        return Arrays.asList(this.inner, this.continuation());
    }

    public static LookAroundTree positiveLookAhead(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.POSITIVE, Direction.AHEAD, element, activeFlags);
    }

    public static LookAroundTree negativeLookAhead(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.NEGATIVE, Direction.AHEAD, element, activeFlags);
    }

    public static LookAroundTree positiveLookBehind(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.POSITIVE, Direction.BEHIND, element, activeFlags);
    }

    public static LookAroundTree negativeLookBehind(RegexSource source, IndexRange range, RegexTree element, FlagSet activeFlags) {
        return new LookAroundTree(source, range, Polarity.NEGATIVE, Direction.BEHIND, element, activeFlags);
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE;

    }

    public static enum Direction {
        AHEAD,
        BEHIND;

    }
}

