/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BranchState;
import org.sonarsource.analyzer.commons.regex.ast.EndOfRepetitionState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;

public class RepetitionTree
extends RegexTree {
    private final RegexTree element;
    private final Quantifier quantifier;

    public RepetitionTree(RegexSource source, IndexRange range, RegexTree element, Quantifier quantifier, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.element = element;
        this.quantifier = quantifier;
    }

    public RegexTree getElement() {
        return this.element;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public boolean isPossessive() {
        return this.quantifier.getModifier() == Quantifier.Modifier.POSSESSIVE;
    }

    public boolean isReluctant() {
        return this.quantifier.getModifier() == Quantifier.Modifier.RELUCTANT;
    }

    @Override
    public void accept(RegexVisitor visitor2) {
        visitor2.visitRepetition(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.REPETITION;
    }

    @Override
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    public List<AutomatonState> successors() {
        if (this.quantifier.getMinimumRepetitions() == 0) {
            Integer max = this.quantifier.getMaximumRepetitions();
            if (max != null && max == 0) {
                return Collections.singletonList(this.continuation());
            }
            return this.flipIfReluctant(this.element, this.continuation());
        }
        return Collections.singletonList(this.element);
    }

    @Override
    public void setContinuation(AutomatonState continuation2) {
        continuation2 = new EndOfRepetitionState(this, continuation2);
        super.setContinuation(continuation2);
        int min = this.quantifier.getMinimumRepetitions();
        Integer max = this.quantifier.getMaximumRepetitions();
        if (max != null && max == 1) {
            this.element.setContinuation(continuation2);
        } else if (min >= 1) {
            this.element.setContinuation(new BranchState(this, this.flipIfReluctant(this, continuation2), this.activeFlags()));
        } else {
            this.element.setContinuation(this);
        }
    }

    private List<AutomatonState> flipIfReluctant(AutomatonState tree1, AutomatonState tree2) {
        if (this.quantifier.getModifier() == Quantifier.Modifier.RELUCTANT) {
            return Arrays.asList(tree2, tree1);
        }
        return Arrays.asList(tree1, tree2);
    }
}

