/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.NewMessageFormatting;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.kotlin.api.checks.InputFileContext;
import org.sonarsource.kotlin.api.checks.InputFileContextImplKt;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ?\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u0014\u0010\u001d\u001a\u00020%*\u00020%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u001c\u0010*\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010(\u001a\u0004\u0018\u00010)H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR,\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lorg/sonarsource/kotlin/api/checks/InputFileContextImpl;", "Lorg/sonarsource/kotlin/api/checks/InputFileContext;", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "isAndroid", "", "<init>", "(Lorg/sonar/api/batch/sensor/SensorContext;Lorg/sonar/api/batch/fs/InputFile;Z)V", "getSensorContext", "()Lorg/sonar/api/batch/sensor/SensorContext;", "getInputFile", "()Lorg/sonar/api/batch/fs/InputFile;", "()Z", "filteredRules", "", "", "", "Lorg/sonar/api/batch/fs/TextRange;", "getFilteredRules", "()Ljava/util/Map;", "setFilteredRules", "(Ljava/util/Map;)V", "reportIssue", "", "ruleKey", "Lorg/sonar/api/rule/RuleKey;", "textRange", "message", "Lorg/sonarsource/kotlin/api/reporting/Message;", "secondaryLocations", "", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "gap", "", "(Lorg/sonar/api/rule/RuleKey;Lorg/sonar/api/batch/fs/TextRange;Lorg/sonarsource/kotlin/api/reporting/Message;Ljava/util/List;Ljava/lang/Double;)V", "Lorg/sonar/api/batch/sensor/issue/NewIssueLocation;", "reportAnalysisParseError", "repositoryKey", "location", "Lorg/sonar/api/batch/fs/TextPointer;", "reportAnalysisError", "sonar-kotlin-api"})
public final class InputFileContextImpl
implements InputFileContext {
    @NotNull
    private final SensorContext sensorContext;
    @NotNull
    private final InputFile inputFile;
    private final boolean isAndroid;
    @NotNull
    private Map<String, ? extends Set<? extends TextRange>> filteredRules;

    public InputFileContextImpl(@NotNull SensorContext sensorContext, @NotNull InputFile inputFile, boolean isAndroid) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
        this.isAndroid = isAndroid;
        this.filteredRules = new HashMap();
    }

    @Override
    @NotNull
    public SensorContext getSensorContext() {
        return this.sensorContext;
    }

    @Override
    @NotNull
    public InputFile getInputFile() {
        return this.inputFile;
    }

    @Override
    public boolean isAndroid() {
        return this.isAndroid;
    }

    @Override
    @NotNull
    public Map<String, Set<TextRange>> getFilteredRules() {
        return this.filteredRules;
    }

    @Override
    public void setFilteredRules(@NotNull Map<String, ? extends Set<? extends TextRange>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.filteredRules = map2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportIssue(@NotNull RuleKey ruleKey, @Nullable TextRange textRange, @NotNull Message message, @NotNull List<SecondaryLocation> secondaryLocations, @Nullable Double gap) {
        void it;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(ruleKey, "ruleKey");
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(secondaryLocations, "secondaryLocations");
        if (textRange != null) {
            boolean bl;
            block8: {
                Set<Object> set = this.getFilteredRules().get(ruleKey.toString());
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        TextRange it2 = (TextRange)element$iv2;
                        boolean bl2 = false;
                        if (!KotlinTextRanges.INSTANCE.contains(it2, textRange)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
        }
        NewIssue $this$reportIssue_u24lambda_u242 = this.getSensorContext().newIssue();
        boolean bl = false;
        $this$reportIssue_u24lambda_u242.forRule(ruleKey);
        NewIssueLocation newIssueLocation = $this$reportIssue_u24lambda_u242.newLocation().on((InputComponent)this.getInputFile());
        Intrinsics.checkNotNullExpressionValue(newIssueLocation, "on(...)");
        element$iv2 = this.message(newIssueLocation, message);
        NewIssue newIssue = $this$reportIssue_u24lambda_u242;
        boolean bl3 = false;
        TextRange textRange2 = textRange;
        newIssue.at((NewIssueLocation)(textRange2 != null ? it.at(textRange2) : it));
        $this$reportIssue_u24lambda_u242.gap(gap);
        for (SecondaryLocation secondary : secondaryLocations) {
            NewIssueLocation newIssueLocation2 = $this$reportIssue_u24lambda_u242.newLocation().on((InputComponent)this.getInputFile()).at(secondary.getTextRange());
            String string2 = secondary.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            $this$reportIssue_u24lambda_u242.addLocation(newIssueLocation2.message(string2));
        }
        $this$reportIssue_u24lambda_u242.save();
    }

    /*
     * WARNING - void declaration
     */
    private final NewIssueLocation message(NewIssueLocation $this$message, Message message) {
        block4: {
            Object object;
            Object object2 = $this$message;
            try {
                void $this$mapTo$iv$iv;
                NewIssueLocation $this$message_u24lambda_u245 = object2;
                boolean bl = false;
                Iterable $this$map$iv = message.getRanges();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    NewMessageFormatting newMessageFormatting;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    int start = ((Number)pair.component1()).intValue();
                    int end = ((Number)pair.component2()).intValue();
                    NewMessageFormatting $this$message_u24lambda_u245_u24lambda_u244_u24lambda_u243 = newMessageFormatting = $this$message_u24lambda_u245.newMessageFormatting();
                    boolean bl3 = false;
                    $this$message_u24lambda_u245_u24lambda_u244_u24lambda_u243.start(start);
                    $this$message_u24lambda_u245_u24lambda_u244_u24lambda_u243.end(end);
                    $this$message_u24lambda_u245_u24lambda_u244_u24lambda_u243.type(MessageFormatting.Type.CODE);
                    collection.add(newMessageFormatting);
                }
                List formatting = (List)destination$iv$iv;
                object = Result.constructor-impl($this$message_u24lambda_u245.message(message.getText(), formatting));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block4;
            Object e = object = throwable;
            boolean bl = false;
            if (!InputFileContextImplKt.access$getAlreadyLoggedIssueMessageWithHighlightingFailed$p()) {
                InputFileContextImplKt.access$setAlreadyLoggedIssueMessageWithHighlightingFailed$p(true);
                InputFileContextImplKt.access$getLOG$p().info("Code highlighting in issue messages is not supported, using plain text instead.");
            }
            $this$message.message(message.getText());
        }
        return $this$message;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportAnalysisParseError(@NotNull String repositoryKey, @NotNull InputFile inputFile, @Nullable TextPointer location) {
        void it;
        Intrinsics.checkNotNullParameter(repositoryKey, "repositoryKey");
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        this.reportAnalysisError("Unable to parse file: " + inputFile, location);
        RuleKey parsingErrorRuleKey = RuleKey.of((String)repositoryKey, (String)"ParsingError");
        if (this.getSensorContext().activeRules().find(parsingErrorRuleKey) == null) {
            return;
        }
        NewIssue $this$reportAnalysisParseError_u24lambda_u248 = this.getSensorContext().newIssue();
        boolean bl = false;
        $this$reportAnalysisParseError_u24lambda_u248.forRule(parsingErrorRuleKey);
        NewIssueLocation newIssueLocation = $this$reportAnalysisParseError_u24lambda_u248.newLocation().on((InputComponent)inputFile).message("A parsing error occurred in this file.");
        NewIssue newIssue = $this$reportAnalysisParseError_u24lambda_u248;
        boolean bl2 = false;
        newIssue.at((NewIssueLocation)(location != null ? it.at(inputFile.selectLine(location.line())) : it));
        $this$reportAnalysisParseError_u24lambda_u248.save();
    }

    @Override
    public void reportAnalysisError(@Nullable String message, @Nullable TextPointer location) {
        NewAnalysisError $this$reportAnalysisError_u24lambda_u249 = this.getSensorContext().newAnalysisError();
        boolean bl = false;
        if (message != null) {
            $this$reportAnalysisError_u24lambda_u249.message(message);
        }
        $this$reportAnalysisError_u24lambda_u249.onFile(this.getInputFile());
        if (location != null) {
            $this$reportAnalysisError_u24lambda_u249.at(this.getInputFile().newPointer(location.line(), location.lineOffset()));
        }
        $this$reportAnalysisError_u24lambda_u249.save();
    }
}

