/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.kotlin.api.frontend.AbstractPropertyHandlerSensorKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B1\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0010\u001a\u00020\u0011H&J*\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0013H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0019\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/sonarsource/kotlin/api/frontend/AbstractPropertyHandlerSensor;", "Lorg/sonar/api/batch/sensor/Sensor;", "analysisWarnings", "Lorg/sonar/api/notifications/AnalysisWarnings;", "propertyKey", "", "propertyName", "configurationKey", "languageKey", "<init>", "(Lorg/sonar/api/notifications/AnalysisWarnings;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "describe", "", "descriptor", "Lorg/sonar/api/batch/sensor/SensorDescriptor;", "execute", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "reportConsumer", "Lkotlin/Function1;", "Ljava/io/File;", "executeOnFiles", "reportFiles", "", "action", "reportMissingFiles", "sonar-kotlin-api"})
public abstract class AbstractPropertyHandlerSensor
implements Sensor {
    @NotNull
    private final AnalysisWarnings analysisWarnings;
    @NotNull
    private final String propertyKey;
    @NotNull
    private final String propertyName;
    @NotNull
    private final String configurationKey;
    @NotNull
    private final String languageKey;

    protected AbstractPropertyHandlerSensor(@NotNull AnalysisWarnings analysisWarnings, @NotNull String propertyKey, @NotNull String propertyName, @NotNull String configurationKey, @NotNull String languageKey) {
        Intrinsics.checkNotNullParameter(analysisWarnings, "analysisWarnings");
        Intrinsics.checkNotNullParameter(propertyKey, "propertyKey");
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        Intrinsics.checkNotNullParameter(configurationKey, "configurationKey");
        Intrinsics.checkNotNullParameter(languageKey, "languageKey");
        this.analysisWarnings = analysisWarnings;
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.configurationKey = configurationKey;
        this.languageKey = languageKey;
    }

    public void describe(@NotNull SensorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        descriptor2.onlyOnLanguage(this.languageKey).onlyWhenConfiguration(arg_0 -> AbstractPropertyHandlerSensor.describe$lambda$0(this, arg_0)).name("Import of " + this.propertyName + " issues");
    }

    public void execute(@NotNull SensorContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.executeOnFiles(this.reportFiles(context), this.reportConsumer(context));
    }

    @NotNull
    public abstract Function1<File, Unit> reportConsumer(@NotNull SensorContext var1);

    /*
     * WARNING - void declaration
     */
    private final void executeOnFiles(List<? extends File> reportFiles, Function1<? super File, Unit> action) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = reportFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File obj = (File)element$iv$iv;
            boolean bl = false;
            if (!obj.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            AbstractPropertyHandlerSensorKt.access$getLOG$p().info("Importing {}", (Object)file2);
            action.invoke(file2);
        }
        this.reportMissingFiles(reportFiles);
    }

    private final List<File> reportFiles(SensorContext context) {
        List<File> list = ExternalReportProvider.getReportFiles(context, this.configurationKey);
        Intrinsics.checkNotNullExpressionValue(list, "getReportFiles(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportMissingFiles(List<? extends File> reportFiles) {
        void $this$mapTo$iv$iv;
        File file2;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = reportFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            file2 = (File)element$iv$iv;
            boolean bl = false;
            if (!(!file2.exists())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getPath());
        }
        List missingFiles = (List)destination$iv$iv;
        if (!((Collection)missingFiles).isEmpty()) {
            String missingFilesAsString = CollectionsKt.joinToString$default(missingFiles, "\n- ", "\n- ", null, 0, null, null, 60, null);
            String logWarning = StringsKt.trimMargin$default("Unable to import " + this.propertyName + " report file(s):" + missingFilesAsString + "\n                |The report file(s) can not be found. Check that the property '" + this.configurationKey + "' is correctly configured.", null, 1, null);
            AbstractPropertyHandlerSensorKt.access$getLOG$p().warn(logWarning);
            String uiWarning = StringsKt.trimMargin$default("Unable to import " + missingFiles.size() + " " + this.propertyName + " report file(s).\n                |Please check that property '" + this.configurationKey + "' is correctly configured and the analysis logs for more details.", null, 1, null);
            this.analysisWarnings.addUnique(uiWarning);
        }
    }

    private static final boolean describe$lambda$0(AbstractPropertyHandlerSensor this$0, Configuration conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return conf.hasKey(this$0.configurationKey);
    }
}

