/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.standalone.StandaloneAnalysisAPISession;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.kotlin.api.frontend.Environment;
import org.sonarsource.kotlin.api.frontend.KotlinTreeKt;
import org.sonarsource.kotlin.api.frontend.ParseException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/sonarsource/kotlin/api/frontend/KotlinSyntaxStructure;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;Lorg/sonar/api/batch/fs/InputFile;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getInputFile", "()Lorg/sonar/api/batch/fs/InputFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "sonar-kotlin-api"})
public final class KotlinSyntaxStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final Document document;
    @NotNull
    private final InputFile inputFile;

    public KotlinSyntaxStructure(@NotNull KtFile ktFile, @NotNull Document document, @NotNull InputFile inputFile) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        Intrinsics.checkNotNullParameter(document, "document");
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        this.ktFile = ktFile;
        this.document = document;
        this.inputFile = inputFile;
    }

    @NotNull
    public final KtFile getKtFile() {
        return this.ktFile;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final InputFile getInputFile() {
        return this.inputFile;
    }

    @NotNull
    public final KtFile component1() {
        return this.ktFile;
    }

    @NotNull
    public final Document component2() {
        return this.document;
    }

    @NotNull
    public final InputFile component3() {
        return this.inputFile;
    }

    @NotNull
    public final KotlinSyntaxStructure copy(@NotNull KtFile ktFile, @NotNull Document document, @NotNull InputFile inputFile) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        Intrinsics.checkNotNullParameter(document, "document");
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        return new KotlinSyntaxStructure(ktFile, document, inputFile);
    }

    public static /* synthetic */ KotlinSyntaxStructure copy$default(KotlinSyntaxStructure kotlinSyntaxStructure, KtFile ktFile, Document document, InputFile inputFile, int n, Object object) {
        if ((n & 1) != 0) {
            ktFile = kotlinSyntaxStructure.ktFile;
        }
        if ((n & 2) != 0) {
            document = kotlinSyntaxStructure.document;
        }
        if ((n & 4) != 0) {
            inputFile = kotlinSyntaxStructure.inputFile;
        }
        return kotlinSyntaxStructure.copy(ktFile, document, inputFile);
    }

    @NotNull
    public String toString() {
        return "KotlinSyntaxStructure(ktFile=" + this.ktFile + ", document=" + this.document + ", inputFile=" + this.inputFile + ")";
    }

    public int hashCode() {
        int result2 = this.ktFile.hashCode();
        result2 = result2 * 31 + this.document.hashCode();
        result2 = result2 * 31 + this.inputFile.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinSyntaxStructure)) {
            return false;
        }
        KotlinSyntaxStructure kotlinSyntaxStructure = (KotlinSyntaxStructure)other;
        if (!Intrinsics.areEqual(this.ktFile, kotlinSyntaxStructure.ktFile)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.document, kotlinSyntaxStructure.document)) {
            return false;
        }
        return Intrinsics.areEqual(this.inputFile, kotlinSyntaxStructure.inputFile);
    }

    @NotNull
    public static final KotlinSyntaxStructure of(@NotNull String content, @NotNull Environment environment, @NotNull InputFile inputFile) {
        return Companion.of(content, environment, inputFile);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/api/frontend/KotlinSyntaxStructure$Companion;", "", "<init>", "()V", "of", "Lorg/sonarsource/kotlin/api/frontend/KotlinSyntaxStructure;", "content", "", "environment", "Lorg/sonarsource/kotlin/api/frontend/Environment;", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "sonar-kotlin-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSyntaxStructure of(@NotNull String content, @NotNull Environment environment, @NotNull InputFile inputFile) {
            Document document;
            Object v2;
            block4: {
                Intrinsics.checkNotNullParameter(content, "content");
                Intrinsics.checkNotNullParameter(environment, "environment");
                Intrinsics.checkNotNullParameter(inputFile, "inputFile");
                String string2 = FileUtil.toSystemIndependentName(inputFile.file().getPath());
                Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(...)");
                String inputFilePath = string2;
                StandaloneAnalysisAPISession standaloneAnalysisAPISession = environment.getK2session();
                Intrinsics.checkNotNull(standaloneAnalysisAPISession);
                Iterable iterable = (Iterable)CollectionsKt.first((Iterable)standaloneAnalysisAPISession.getModulesWithFiles().values());
                for (Object t : iterable) {
                    PsiFile it = (PsiFile)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getVirtualFile().getPath(), inputFilePath)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile psiFile = v2;
            try {
                Document document2 = psiFile.getViewProvider().getDocument();
                if (document2 == null) {
                    throw new ParseException("Cannot extract document", null, null, 6, null);
                }
                document = document2;
            }
            catch (AssertionError e) {
                throw new ParseException("Cannot correctly map AST with a null Document object", null, null, 6, null);
            }
            Document document3 = document;
            KotlinTreeKt.checkParsingErrors(psiFile, document3, inputFile);
            return new KotlinSyntaxStructure(psiFile, document3, inputFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

