/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.frontend;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonarsource.kotlin.api.frontend.KotlinFileSystem;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u0010\u0010\fJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0011\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010!\u001a\u00020 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0017\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b(\u0010'J)\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010)H\u0017\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010.\u001a\u00020-H\u0017\u00a2\u0006\u0004\b.\u0010/R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00100R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00101R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00102"}, d2={"Lorg/sonarsource/kotlin/api/frontend/KotlinVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileSystem;", "fileSystem", "Ljava/io/File;", "file", "Lkotlin/Function0;", "", "contentProvider", "<init>", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileSystem;Ljava/io/File;Lkotlin/jvm/functions/Function0;)V", "getName", "()Ljava/lang/String;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getFileSystem", "()Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "", "isWritable", "()Z", "isDirectory", "isValid", "getParent", "()Lcom/intellij/openapi/vfs/VirtualFile;", "", "getChildren", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "", "p0", "", "p1", "p2", "Ljava/io/OutputStream;", "getOutputStream", "(Ljava/lang/Object;JJ)Ljava/io/OutputStream;", "", "contentsToByteArray", "()[B", "getTimeStamp", "()J", "getLength", "Ljava/lang/Runnable;", "", "refresh", "(ZZLjava/lang/Runnable;)Ljava/lang/Void;", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileSystem;", "Ljava/io/File;", "Lkotlin/jvm/functions/Function0;"})
public final class KotlinVirtualFile
extends VirtualFile {
    @NotNull
    private final KotlinFileSystem fileSystem;
    @NotNull
    private final File file;
    @Nullable
    private final Function0<String> contentProvider;

    public KotlinVirtualFile(@NotNull KotlinFileSystem fileSystem, @NotNull File file2, @Nullable Function0<String> contentProvider) {
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(file2, "file");
        this.fileSystem = fileSystem;
        this.file = file2;
        this.contentProvider = contentProvider;
    }

    public /* synthetic */ KotlinVirtualFile(KotlinFileSystem kotlinFileSystem, File file2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        this(kotlinFileSystem, file2, function0);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.file.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        return string2;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string2 = FileUtil.toSystemIndependentName(this.file.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(...)");
        return string2;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        File file2 = this.file.getParentFile();
        if (file2 == null) {
            return null;
        }
        File parentFile = file2;
        return new KotlinVirtualFile(this.fileSystem, parentFile, null, 4, null);
    }

    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        if (this.file.isFile() || !this.file.exists()) {
            return new VirtualFile[0];
        }
        throw new UnsupportedOperationException("getChildren " + this.file.getAbsolutePath());
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@Nullable Object p0, long p1, long p2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        if (this.contentProvider != null) {
            String string2 = this.contentProvider.invoke();
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            return byArray;
        }
        byte[] byArray = FileUtil.loadFileBytes(this.file);
        Intrinsics.checkNotNullExpressionValue(byArray, "loadFileBytes(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @NotNull
    public Void refresh(boolean p0, boolean p1, @Nullable Runnable p2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }
}

