/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.sensors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.psi.KtFile;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.kotlin.api.checks.InputFileContext;
import org.sonarsource.kotlin.api.checks.InputFileContextImpl;
import org.sonarsource.kotlin.api.common.MeasureDurationKt;
import org.sonarsource.kotlin.api.frontend.Environment;
import org.sonarsource.kotlin.api.frontend.K2Kt;
import org.sonarsource.kotlin.api.frontend.KotlinFileSystem;
import org.sonarsource.kotlin.api.frontend.KotlinSyntaxStructure;
import org.sonarsource.kotlin.api.frontend.KotlinTree;
import org.sonarsource.kotlin.api.frontend.KotlinVirtualFile;
import org.sonarsource.kotlin.api.frontend.ParseException;
import org.sonarsource.kotlin.api.sensors.AbstractKotlinSensorExecuteContextKt;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010#\u001a\u00020\u0013J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0012\u0010\u0014R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0016\u001a\u0004\b!\u0010\u0019\u00a8\u0006."}, d2={"Lorg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContext;", "", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "inputFiles", "", "Lorg/sonar/api/batch/fs/InputFile;", "progressReport", "Lorg/sonarsource/analyzer/commons/ProgressReport;", "visitors", "", "Lorg/sonarsource/kotlin/api/visiting/KotlinFileVisitor;", "filenames", "", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lorg/sonar/api/batch/sensor/SensorContext;Ljava/lang/Iterable;Lorg/sonarsource/analyzer/commons/ProgressReport;Ljava/util/List;Ljava/util/List;Lorg/slf4j/Logger;)V", "isInAndroidContext", "", "()Z", "isInAndroidContext$delegate", "Lkotlin/Lazy;", "classpath", "getClasspath", "()Ljava/util/List;", "environment", "Lorg/sonarsource/kotlin/api/frontend/Environment;", "getEnvironment", "()Lorg/sonarsource/kotlin/api/frontend/Environment;", "environment$delegate", "kotlinFiles", "Lorg/sonarsource/kotlin/api/frontend/KotlinSyntaxStructure;", "getKotlinFiles", "kotlinFiles$delegate", "analyzeFiles", "analyzeFile", "", "inputFileContext", "Lorg/sonarsource/kotlin/api/checks/InputFileContext;", "tree", "Lorg/sonarsource/kotlin/api/frontend/KotlinTree;", "logParsingError", "inputFile", "e", "Lorg/sonarsource/kotlin/api/frontend/ParseException;", "sonar-kotlin-api"})
public abstract class AbstractKotlinSensorExecuteContext {
    @NotNull
    private final SensorContext sensorContext;
    @NotNull
    private final Iterable<InputFile> inputFiles;
    @NotNull
    private final ProgressReport progressReport;
    @NotNull
    private final List<KotlinFileVisitor> visitors;
    @NotNull
    private final List<String> filenames;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy isInAndroidContext$delegate;
    @NotNull
    private final Lazy environment$delegate;
    @NotNull
    private final Lazy kotlinFiles$delegate;

    public AbstractKotlinSensorExecuteContext(@NotNull SensorContext sensorContext, @NotNull Iterable<? extends InputFile> inputFiles, @NotNull ProgressReport progressReport, @NotNull List<? extends KotlinFileVisitor> visitors, @NotNull List<String> filenames, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(inputFiles, "inputFiles");
        Intrinsics.checkNotNullParameter(progressReport, "progressReport");
        Intrinsics.checkNotNullParameter(visitors, "visitors");
        Intrinsics.checkNotNullParameter(filenames, "filenames");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.sensorContext = sensorContext;
        this.inputFiles = inputFiles;
        this.progressReport = progressReport;
        this.visitors = visitors;
        this.filenames = filenames;
        this.logger = logger;
        this.isInAndroidContext$delegate = LazyKt.lazy(() -> AbstractKotlinSensorExecuteContext.isInAndroidContext_delegate$lambda$0(this));
        this.environment$delegate = LazyKt.lazy(() -> AbstractKotlinSensorExecuteContext.environment_delegate$lambda$3(this));
        this.kotlinFiles$delegate = LazyKt.lazy(() -> AbstractKotlinSensorExecuteContext.kotlinFiles_delegate$lambda$5(this));
    }

    private final boolean isInAndroidContext() {
        Lazy lazy = this.isInAndroidContext$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Boolean)t;
    }

    @NotNull
    public abstract List<String> getClasspath();

    @NotNull
    public final Environment getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Environment)lazy.getValue();
    }

    @NotNull
    public final List<KotlinSyntaxStructure> getKotlinFiles() {
        Lazy lazy = this.kotlinFiles$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean analyzeFiles() {
        try {
            void $this$filterTo$iv$iv;
            this.progressReport.start((Iterable<String>)this.filenames);
            Iterable $this$filter$iv = this.getKotlinFiles();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KotlinSyntaxStructure it = (KotlinSyntaxStructure)element$iv$iv;
                boolean bl = false;
                Regex regex = AbstractKotlinSensorExecuteContextKt.access$getEMPTY_FILE_CONTENT_PATTERN$p();
                String string2 = it.getInputFile().contents();
                Intrinsics.checkNotNullExpressionValue(string2, "contents(...)");
                if (!(!regex.matches(string2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinSyntaxStructure kotlinSyntaxStructure = (KotlinSyntaxStructure)element$iv;
                boolean bl = false;
                KtFile ktFile = kotlinSyntaxStructure.component1();
                Document doc = kotlinSyntaxStructure.component2();
                InputFile inputFile = kotlinSyntaxStructure.component3();
                if (this.sensorContext.isCancelled()) {
                    boolean bl2 = false;
                    return bl2;
                }
                InputFileContextImpl inputFileContext = new InputFileContextImpl(this.sensorContext, inputFile, this.isInAndroidContext());
                KotlinTree tree = new KotlinTree(ktFile, doc);
                String string3 = inputFile.filename();
                Intrinsics.checkNotNullExpressionValue(string3, "filename(...)");
                MeasureDurationKt.measureDuration(string3, () -> AbstractKotlinSensorExecuteContext.analyzeFiles$lambda$8$lambda$7(this, inputFileContext, tree));
                this.progressReport.nextFile();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Disposer.dispose(this.getEnvironment().getDisposable());
        }
    }

    private final void analyzeFile(InputFileContext inputFileContext, KotlinTree tree) {
        Iterable $this$forEach$iv = this.visitors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinFileVisitor visitor2 = (KotlinFileVisitor)element$iv;
            boolean bl = false;
            String visitorId = visitor2.getClass().getSimpleName();
            try {
                Intrinsics.checkNotNull(visitorId);
                MeasureDurationKt.measureDuration(visitorId, () -> AbstractKotlinSensorExecuteContext.analyzeFile$lambda$10$lambda$9(visitor2, inputFileContext, tree));
            }
            catch (Exception e) {
                inputFileContext.reportAnalysisError(e.getMessage(), null);
                this.logger.error("Cannot analyse '" + inputFileContext.getInputFile() + "' with '" + visitorId + "': " + e.getMessage(), (Throwable)e);
                if (!this.sensorContext.config().getBoolean("sonar.internal.analysis.failFast").orElse(false).booleanValue()) continue;
                throw new IllegalStateException("Exception in '" + visitorId + "' while analyzing '" + inputFileContext.getInputFile() + "'", e);
            }
        }
    }

    private final void logParsingError(InputFile inputFile, ParseException e) {
        block1: {
            TextPointer position = e.getPosition();
            Object positionMessage = "";
            if (position != null) {
                positionMessage = "Parse error at position " + position.line() + ":" + position.lineOffset();
            }
            this.logger.error("Unable to parse file: " + inputFile.uri() + ". " + (String)positionMessage);
            String string2 = e.getMessage();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            this.logger.error(it);
        }
    }

    private static final Boolean isInAndroidContext_delegate$lambda$0(AbstractKotlinSensorExecuteContext this$0) {
        return this$0.sensorContext.config().getBoolean("sonar.android.detected").orElse(false);
    }

    private static final String environment_delegate$lambda$3$lambda$2$lambda$1(InputFile $it) {
        String string2 = $it.contents();
        Intrinsics.checkNotNullExpressionValue(string2, "contents(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Environment environment_delegate$lambda$3(AbstractKotlinSensorExecuteContext this$0) {
        Collection<KotlinVirtualFile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable(...)");
        Environment env = new Environment(disposable, this$0.getClasspath(), AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion(this$0.sensorContext, this$0.logger), null, 8, null);
        KotlinFileSystem virtualFileSystem = new KotlinFileSystem();
        Iterable<InputFile> iterable = this$0.inputFiles;
        CompilerConfiguration compilerConfiguration = env.getConfiguration();
        Disposable disposable2 = env.getDisposable();
        Environment environment = env;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InputFile inputFile = (InputFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KotlinVirtualFile(virtualFileSystem, new File(it.uri().getPath()), () -> AbstractKotlinSensorExecuteContext.environment_delegate$lambda$3$lambda$2$lambda$1((InputFile)it)));
        }
        collection = (List)destination$iv$iv;
        environment.setK2session(K2Kt.createK2AnalysisSession(disposable2, compilerConfiguration, (Collection<? extends VirtualFile>)collection));
        return env;
    }

    /*
     * WARNING - void declaration
     */
    private static final List kotlinFiles_delegate$lambda$5(AbstractKotlinSensorExecuteContext this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<InputFile> $this$mapNotNull$iv = this$0.inputFiles;
        boolean $i$f$mapNotNull = false;
        Iterable<InputFile> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinSyntaxStructure it$iv$iv;
            KotlinSyntaxStructure kotlinSyntaxStructure;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            InputFile it = (InputFile)element$iv$iv;
            boolean bl2 = false;
            InputFileContextImpl inputFileContext = new InputFileContextImpl(this$0.sensorContext, it, this$0.isInAndroidContext());
            try {
                String string2 = it.contents();
                Intrinsics.checkNotNullExpressionValue(string2, "contents(...)");
                kotlinSyntaxStructure = KotlinSyntaxStructure.Companion.of(string2, this$0.getEnvironment(), it);
            }
            catch (ParseException e) {
                this$0.logParsingError(it, AbstractKotlinSensorExecuteContextKt.access$toParseException("parse", it, e));
                inputFileContext.reportAnalysisParseError("kotlin", it, e.getPosition());
                kotlinSyntaxStructure = null;
            }
            catch (Exception e) {
                ParseException parseException = AbstractKotlinSensorExecuteContextKt.access$toParseException("read", it, e);
                this$0.logParsingError(it, parseException);
                inputFileContext.reportAnalysisParseError("kotlin", it, parseException.getPosition());
                kotlinSyntaxStructure = null;
            }
            if (kotlinSyntaxStructure == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit analyzeFiles$lambda$8$lambda$7(AbstractKotlinSensorExecuteContext this$0, InputFileContextImpl $inputFileContext, KotlinTree $tree) {
        this$0.analyzeFile($inputFileContext, $tree);
        return Unit.INSTANCE;
    }

    private static final Unit analyzeFile$lambda$10$lambda$9(KotlinFileVisitor $visitor, InputFileContext $inputFileContext, KotlinTree $tree) {
        $visitor.scan($inputFileContext, $tree);
        return Unit.INSTANCE;
    }
}

