/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.sensors;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.kotlin.api.common.ConstantsKt;
import org.sonarsource.kotlin.api.frontend.ParseException;
import org.sonarsource.kotlin.api.logging.LoggerExtensionsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"EMPTY_FILE_CONTENT_PATTERN", "Lkotlin/text/Regex;", "determineKotlinLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "logger", "Lorg/slf4j/Logger;", "toParseException", "Lorg/sonarsource/kotlin/api/frontend/ParseException;", "action", "", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "cause", "", "sonar-kotlin-api"})
public final class AbstractKotlinSensorExecuteContextKt {
    @NotNull
    private static final Regex EMPTY_FILE_CONTENT_PATTERN = new Regex("\\s*+");

    @NotNull
    public static final LanguageVersion determineKotlinLanguageVersion(@NotNull SensorContext sensorContext, @NotNull Logger logger) {
        LanguageVersion languageVersion;
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(logger, "logger");
        LanguageVersion languageVersion2 = sensorContext.config().get("sonar.kotlin.source.version").map(arg_0 -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$2(arg_0 -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$1(logger, arg_0), arg_0)).orElse(null);
        if (languageVersion2 == null) {
            languageVersion2 = ConstantsKt.getDEFAULT_KOTLIN_LANGUAGE_VERSION();
        }
        LanguageVersion it = languageVersion = languageVersion2;
        boolean bl = false;
        LoggerExtensionsKt.debug(logger, () -> AbstractKotlinSensorExecuteContextKt.determineKotlinLanguageVersion$lambda$4$lambda$3(it));
        return languageVersion;
    }

    private static final ParseException toParseException(String action, InputFile inputFile, Throwable cause) {
        ParseException parseException = cause instanceof ParseException ? (ParseException)cause : null;
        return new ParseException("Cannot " + action + " '" + inputFile + "': " + cause.getMessage(), (TextPointer)(parseException != null ? parseException.getPosition() : null), cause);
    }

    private static final LanguageVersion determineKotlinLanguageVersion$lambda$1(Logger $logger, String versionString) {
        LanguageVersion languageVersion;
        LanguageVersion langVersion = languageVersion = LanguageVersion.Companion.fromVersionString(versionString);
        boolean bl = false;
        if (langVersion == null) {
            Intrinsics.checkNotNull(versionString);
            if (!StringsKt.isBlank(versionString)) {
                $logger.warn("Failed to find Kotlin version '" + versionString + "'. Defaulting to " + ConstantsKt.getDEFAULT_KOTLIN_LANGUAGE_VERSION().getVersionString());
            }
        }
        return languageVersion;
    }

    private static final LanguageVersion determineKotlinLanguageVersion$lambda$2(Function1 $tmp0, Object p0) {
        return (LanguageVersion)$tmp0.invoke(p0);
    }

    private static final String determineKotlinLanguageVersion$lambda$4$lambda$3(LanguageVersion $it) {
        return "Using Kotlin " + $it.getVersionString() + " to parse source code";
    }

    public static final /* synthetic */ ParseException access$toParseException(String action, InputFile inputFile, Throwable cause) {
        return AbstractKotlinSensorExecuteContextKt.toParseException(action, inputFile, cause);
    }

    public static final /* synthetic */ Regex access$getEMPTY_FILE_CONTENT_PATTERN$p() {
        return EMPTY_FILE_CONTENT_PATTERN;
    }
}

