/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.ConditionalStructure;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH$\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H$\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/AbstractBranchDuplication;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "ctx", "Lorg/jetbrains/kotlin/psi/KtElement;", "tree", "", "branches", "", "checkDuplicatedBranches", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "onAllIdenticalBranches", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Lorg/jetbrains/kotlin/psi/KtElement;)V", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "expression", "context", "visitIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhenExpression", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/sonarsource/kotlin/checks/ConditionalStructure;", "conditional", "checkConditionalStructure", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/sonarsource/kotlin/checks/ConditionalStructure;)V"})
public abstract class AbstractBranchDuplication
extends AbstractCheck {
    protected abstract void checkDuplicatedBranches(@NotNull KotlinFileContext var1, @NotNull KtElement var2, @NotNull List<? extends KtElement> var3);

    protected abstract void onAllIdenticalBranches(@NotNull KotlinFileContext var1, @NotNull KtElement var2);

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement parent2 = expression.getParent().getParent();
        if (!(parent2 instanceof KtIfExpression) || Intrinsics.areEqual(expression, ((KtIfExpression)parent2).getThen())) {
            this.checkConditionalStructure(context, expression, new ConditionalStructure(expression));
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        this.checkConditionalStructure(context, expression, new ConditionalStructure(expression));
    }

    private final void checkConditionalStructure(KotlinFileContext ctx, KtElement tree, ConditionalStructure conditional) {
        if (conditional.getAllBranchesArePresent() && conditional.allBranchesAreIdentical()) {
            this.onAllIdenticalBranches(ctx, tree);
        } else {
            this.checkDuplicatedBranches(ctx, tree, conditional.getBranches());
        }
    }
}

