/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.BiometricAuthWithoutCryptoCheckKt;

@Rule(key="S6293")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00158\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/sonarsource/kotlin/checks/BiometricAuthWithoutCryptoCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "ctx", "", "numberOfSafeArgs", "argumentIndex", "checkCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;II)V", "", "functionsToVisit", "Ljava/util/Set;", "getFunctionsToVisit", "()Ljava/util/Set;"})
public final class BiometricAuthWithoutCryptoCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit;

    public BiometricAuthWithoutCryptoCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{BiometricAuthWithoutCryptoCheckKt.access$getANDROID_HARDWARE_AUTH$p(), BiometricAuthWithoutCryptoCheckKt.access$getANDROIDX_AUTH$p()};
        this.functionsToVisit = SetsKt.setOf(funMatcherImplArray);
    }

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        FunMatcherImpl funMatcherImpl = matchedFun;
        if (Intrinsics.areEqual(funMatcherImpl, BiometricAuthWithoutCryptoCheckKt.access$getANDROID_HARDWARE_AUTH$p())) {
            this.checkCall(callExpression, kotlinFileContext, 4, 0);
        } else if (Intrinsics.areEqual(funMatcherImpl, BiometricAuthWithoutCryptoCheckKt.access$getANDROIDX_AUTH$p())) {
            this.checkCall(callExpression, kotlinFileContext, 2, 1);
        }
    }

    private final void checkCall(KtCallExpression callExpression, KotlinFileContext ctx, int numberOfSafeArgs, int argumentIndex) {
        block2: {
            block1: {
                if (callExpression.getValueArguments().size() >= numberOfSafeArgs) break block1;
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)callExpression, "Make sure performing a biometric authentication without a \"CryptoObject\" is safe here.", null, null, 12, null);
                break block2;
            }
            KtExpression ktExpression = callExpression.getValueArguments().get(argumentIndex).getArgumentExpression();
            if (ktExpression == null) break block2;
            KtExpression relevantArg = ktExpression;
            boolean bl = false;
            if (PsiUtilsKt.isNull(relevantArg)) {
                KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression(callExpression);
                KtReferenceExpression secondaryExpression = ktSimpleNameExpression != null ? (KtReferenceExpression)ktSimpleNameExpression : (KtReferenceExpression)callExpression;
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)relevantArg, "Make sure performing a biometric authentication without a \"CryptoObject\" is safe here.", CollectionsKt.listOf(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(ctx, secondaryExpression), null, 2, null)), null, 8, null);
            }
        }
    }
}

