/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.CodeAfterJumpCheckKt;

@Rule(key="S1763")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/sonarsource/kotlin/checks/CodeAfterJumpCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitBlockExpression", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "statementsOrExpressions", "checkStatements", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Ljava/util/List;)V"})
public final class CodeAfterJumpCheck
extends AbstractCheck {
    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        List<KtExpression> list = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        this.checkStatements(context, list);
    }

    private final void checkStatements(KotlinFileContext context, List<? extends KtElement> statementsOrExpressions) {
        int n = statementsOrExpressions.size() - 1;
        for (int i = 0; i < n; ++i) {
            String it;
            KtElement current = statementsOrExpressions.get(i);
            if (CodeAfterJumpCheckKt.access$getJump(current) == null) continue;
            boolean bl = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)current, "Refactor this piece of code to not have any dead code after this \"" + it + "\".", null, null, 12, null);
        }
    }
}

