/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u000e*\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/CognitiveComplexity;", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "root", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "", "value", "()I", "", "Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "increments", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "isLogicalBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "Lorg/jetbrains/kotlin/psi/KtElement;", "getRoot", "()Lorg/jetbrains/kotlin/psi/KtElement;", "", "Ljava/util/List;", "Increment", "CognitiveComplexityVisitor"})
public final class CognitiveComplexity {
    @NotNull
    private final KtElement root;
    @NotNull
    private final List<Increment> increments;

    public CognitiveComplexity(@NotNull KtElement root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.root = root;
        this.increments = new ArrayList();
        CognitiveComplexityVisitor visitor2 = new CognitiveComplexityVisitor();
        this.root.accept(visitor2);
    }

    @NotNull
    public final KtElement getRoot() {
        return this.root;
    }

    public final int value() {
        int total = 0;
        for (Increment increment : this.increments) {
            total += increment.getNestingLevel() + 1;
        }
        return total;
    }

    @NotNull
    public final List<Increment> increments() {
        return this.increments;
    }

    private final boolean isLogicalBinaryExpression(KtExpression $this$isLogicalBinaryExpression) {
        return $this$isLogicalBinaryExpression instanceof KtBinaryExpression && (Intrinsics.areEqual(((KtBinaryExpression)$this$isLogicalBinaryExpression).getOperationToken(), KtTokens.ANDAND) || Intrinsics.areEqual(((KtBinaryExpression)$this$isLogicalBinaryExpression).getOperationToken(), KtTokens.OROR));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\"J!\u0010&\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010*\u001a\u00020\u00062\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b*\u0010+R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010."}, d2={"Lorg/sonarsource/kotlin/checks/CognitiveComplexity$CognitiveComplexityVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "(Lorg/sonarsource/kotlin/checks/CognitiveComplexity;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "", "visitExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "catchClause", "visitCatchSection", "(Lorg/jetbrains/kotlin/psi/KtCatchClause;)V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "tree", "handleBinaryExpressions", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "operators", "flattenOperators", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Ljava/util/List;)V", "Lcom/intellij/psi/PsiElement;", "token", "Lorg/jetbrains/kotlin/psi/KtElement;", "incrementWithNesting", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtElement;)V", "incrementWithoutNesting", "(Lcom/intellij/psi/PsiElement;)V", "", "nestingLevel", "increment", "(Lcom/intellij/psi/PsiElement;I)V", "ktElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)I", "parent", "t", "", "isElseIfBranch", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtElement;)Z", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "ifExpression", "handleIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)V", "", "alreadyConsideredOperators", "Ljava/util/Set;"})
    private final class CognitiveComplexityVisitor
    extends KtTreeVisitorVoid {
        @NotNull
        private final Set<KtOperationReferenceExpression> alreadyConsideredOperators = new HashSet();

        @Override
        public void visitExpression(@NotNull KtExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            KtExpression ktExpression = expression;
            if (ktExpression instanceof KtForExpression) {
                PsiElement psiElement = ((KtForExpression)expression).getForKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getForKeyword(...)");
                this.incrementWithNesting(psiElement, expression);
            } else if (ktExpression instanceof KtWhileExpression) {
                PsiElement psiElement = ((KtWhileExpression)expression).getFirstChild();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
                this.incrementWithNesting(psiElement, expression);
            } else if (ktExpression instanceof KtWhenExpression) {
                PsiElement psiElement = ((KtWhenExpression)expression).getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
                this.incrementWithNesting(psiElement, expression);
            } else if (ktExpression instanceof KtBreakExpression) {
                KtContainerNode ktContainerNode = ((KtBreakExpression)expression).getLabelQualifier();
                if (ktContainerNode != null) {
                    KtContainerNode it = ktContainerNode;
                    boolean bl = false;
                    PsiElement psiElement = ((KtBreakExpression)expression).getFirstChild();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
                    this.incrementWithoutNesting(psiElement);
                }
            } else if (ktExpression instanceof KtContinueExpression) {
                KtContainerNode ktContainerNode = ((KtContinueExpression)expression).getLabelQualifier();
                if (ktContainerNode != null) {
                    KtContainerNode it = ktContainerNode;
                    boolean bl = false;
                    PsiElement psiElement = ((KtContinueExpression)expression).getFirstChild();
                    Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
                    this.incrementWithoutNesting(psiElement);
                }
            } else if (ktExpression instanceof KtIfExpression) {
                this.handleIfExpression((KtIfExpression)expression);
            } else if (ktExpression instanceof KtBinaryExpression) {
                this.handleBinaryExpressions((KtBinaryExpression)expression);
            }
            super.visitExpression(expression);
        }

        @Override
        public void visitCatchSection(@NotNull KtCatchClause catchClause) {
            Intrinsics.checkNotNullParameter(catchClause, "catchClause");
            PsiElement psiElement = catchClause.getFirstChild();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getFirstChild(...)");
            this.incrementWithNesting(psiElement, catchClause);
            super.visitCatchSection(catchClause);
        }

        private final void handleBinaryExpressions(KtBinaryExpression tree) {
            if (!CognitiveComplexity.this.isLogicalBinaryExpression(tree) || this.alreadyConsideredOperators.contains(tree.getOperationReference())) {
                return;
            }
            List operators = new ArrayList();
            this.flattenOperators(tree, operators);
            KtOperationReferenceExpression previous = null;
            for (KtOperationReferenceExpression operator : operators) {
                block6: {
                    block5: {
                        if (previous == null) break block5;
                        KtSingleValueToken ktSingleValueToken = previous.getOperationSignTokenType();
                        KtSingleValueToken ktSingleValueToken2 = operator.getOperationSignTokenType();
                        if (Intrinsics.areEqual(ktSingleValueToken != null ? ktSingleValueToken.getValue() : null, ktSingleValueToken2 != null ? ktSingleValueToken2.getValue() : null)) break block6;
                    }
                    this.incrementWithoutNesting(operator);
                }
                previous = operator;
                this.alreadyConsideredOperators.add(operator);
            }
        }

        private final void flattenOperators(KtBinaryExpression tree, List<KtOperationReferenceExpression> operators) {
            if (CognitiveComplexity.this.isLogicalBinaryExpression(tree.getLeft())) {
                KtExpression ktExpression = tree.getLeft();
                Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                this.flattenOperators((KtBinaryExpression)ktExpression, operators);
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = tree.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            operators.add(ktOperationReferenceExpression);
            if (CognitiveComplexity.this.isLogicalBinaryExpression(tree.getRight())) {
                KtExpression ktExpression = tree.getRight();
                Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                this.flattenOperators((KtBinaryExpression)ktExpression, operators);
            }
        }

        private final void incrementWithNesting(PsiElement token, KtElement tree) {
            this.increment(token, this.nestingLevel(tree));
        }

        private final void incrementWithoutNesting(PsiElement token) {
            this.increment(token, 0);
        }

        private final void increment(PsiElement token, int nestingLevel) {
            CognitiveComplexity.this.increments.add(new Increment(token, nestingLevel));
        }

        private final int nestingLevel(KtElement ktElement) {
            int nestingLevel = 0;
            boolean isInsideFunction = CognitiveComplexity.this.getRoot() instanceof KtFunction;
            ArrayDeque<PsiElement> ancestors = new ArrayDeque<PsiElement>();
            for (PsiElement parent2 = ktElement.getParent(); parent2 != null && !Intrinsics.areEqual(parent2, CognitiveComplexity.this.getRoot()); parent2 = parent2.getParent()) {
                ancestors.addFirst(parent2);
            }
            for (PsiElement element : ancestors) {
                block9: {
                    block8: {
                        block7: {
                            if (element instanceof KtFunction) {
                                if (isInsideFunction) {
                                    ++nestingLevel;
                                }
                                isInsideFunction = true;
                                continue;
                            }
                            if (!(element instanceof KtIfExpression)) break block7;
                            PsiElement psiElement = ((KtIfExpression)element).getParent();
                            if (!this.isElseIfBranch(psiElement != null ? psiElement.getParent() : null, (KtElement)element)) break block8;
                        }
                        if (!(element instanceof KtWhenExpression) && !(element instanceof KtLoopExpression) && !(element instanceof KtCatchClause)) break block9;
                    }
                    ++nestingLevel;
                    continue;
                }
                if (!(element instanceof KtClass)) continue;
                nestingLevel = 0;
                isInsideFunction = false;
            }
            return nestingLevel;
        }

        private final boolean isElseIfBranch(PsiElement parent2, KtElement t) {
            return parent2 instanceof KtIfExpression && ((KtIfExpression)parent2).getElse() == t;
        }

        private final void handleIfExpression(KtIfExpression ifExpression) {
            block2: {
                boolean isElseIf;
                PsiElement parent2;
                PsiElement psiElement = parent2 = ifExpression.getParent();
                PsiElement preParent = psiElement != null ? psiElement.getParent() : null;
                boolean bl = isElseIf = preParent instanceof KtIfExpression && ifExpression == ((KtIfExpression)preParent).getElse();
                if (!isElseIf) {
                    PsiElement psiElement2 = ifExpression.getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue(psiElement2, "getIfKeyword(...)");
                    this.incrementWithNesting(psiElement2, ifExpression);
                }
                KtExpression ktExpression = ifExpression.getElse();
                if (ktExpression == null) break block2;
                KtExpression it = ktExpression;
                boolean bl2 = false;
                if (it instanceof KtBlockExpression || it instanceof KtIfExpression) {
                    PsiElement psiElement3 = ifExpression.getElseKeyword();
                    Intrinsics.checkNotNull(psiElement3);
                    this.incrementWithoutNesting(psiElement3);
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "", "Lcom/intellij/psi/PsiElement;", "token", "", "nestingLevel", "<init>", "(Lcom/intellij/psi/PsiElement;I)V", "Lcom/intellij/psi/PsiElement;", "getToken", "()Lcom/intellij/psi/PsiElement;", "I", "getNestingLevel", "()I"})
    public static final class Increment {
        @NotNull
        private final PsiElement token;
        private final int nestingLevel;

        public Increment(@NotNull PsiElement token, int nestingLevel) {
            Intrinsics.checkNotNullParameter(token, "token");
            this.token = token;
            this.nestingLevel = nestingLevel;
        }

        @NotNull
        public final PsiElement getToken() {
            return this.token;
        }

        public final int getNestingLevel() {
            return this.nestingLevel;
        }
    }
}

