/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.CollectionInappropriateCallsCheckKt;

@Rule(key="S2175")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/CollectionInappropriateCallsCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class CollectionInappropriateCallsCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public CollectionInappropriateCallsCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{CollectionInappropriateCallsCheckKt.getCOLLECTION_EXTENSIONS_MATCHER(), CollectionInappropriateCallsCheckKt.getCOLLECTION_ARGUMENT_EXTENSIONS_MATCHER(), CollectionInappropriateCallsCheckKt.getCONTAINS_VALUE_MATCHER()};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u240 = kaSession;
        boolean bl = false;
        List<KtValueArgument> list = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        KtValueArgument arg = CollectionsKt.first(list);
        Object object = arg.getArgumentExpression();
        if (object == null || (object = $this$visitFunctionCall_u24lambda_u240.getExpressionType((KtExpression)object)) == null) {
            return;
        }
        Object argType = object;
        KtExpression ktExpression = ApiExtensionsKt.predictReceiverExpression(callExpression);
        KaType kaType = ktExpression != null ? $this$visitFunctionCall_u24lambda_u240.getExpressionType(ktExpression) : null;
        KaClassType kaClassType = kaType instanceof KaClassType ? (KaClassType)kaType : null;
        if (kaClassType == null) {
            return;
        }
        KaClassType collectionType = kaClassType;
        Integer n = CollectionInappropriateCallsCheckKt.getFunMatcherToArgumentIndexMap().get(matchedFun);
        Intrinsics.checkNotNull(n);
        int collectionArgumentIndex = ((Number)n).intValue();
        KaType kaType2 = $this$visitFunctionCall_u24lambda_u240.getArrayElementType(collectionType);
        if (kaType2 == null) {
            KaTypeProjection kaTypeProjection = CollectionsKt.getOrNull(collectionType.getTypeArguments(), collectionArgumentIndex);
            kaType2 = kaTypeProjection != null ? kaTypeProjection.getType() : null;
            if (kaType2 == null) {
                return;
            }
        }
        KaType collectionArgumentType = kaType2;
        if (Intrinsics.areEqual(matchedFun, CollectionInappropriateCallsCheckKt.getCOLLECTION_ARGUMENT_EXTENSIONS_MATCHER())) {
            if (!(argType instanceof KaClassType)) {
                return;
            }
            KaLifetimeOwner kaLifetimeOwner = CollectionsKt.firstOrNull(((KaClassType)argType).getTypeArguments());
            if (kaLifetimeOwner == null || (kaLifetimeOwner = kaLifetimeOwner.getType()) == null) {
                return;
            }
            argType = kaLifetimeOwner;
        }
        if (argType instanceof KaTypeParameterType || collectionArgumentType instanceof KaTypeParameterType) {
            return;
        }
        if (!(KaTypeRelationChecker.semanticallyEquals$default($this$visitFunctionCall_u24lambda_u240, (KaType)argType, collectionArgumentType, null, 2, null) || KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$visitFunctionCall_u24lambda_u240, (KaType)argType, collectionArgumentType, null, 2, null) || KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$visitFunctionCall_u24lambda_u240, collectionArgumentType, (KaType)argType, null, 2, null))) {
            AbstractCheck abstractCheck = this;
            Intrinsics.checkNotNull(arg);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)arg, "This key/object cannot ever be present in the collection", null, null, 12, null);
        }
    }
}

