/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtElement;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u000e\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/sonarsource/kotlin/checks/ComparableTree;", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "tree", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/psi/KtElement;", "hash", "I", "Companion"})
public final class ComparableTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtElement tree;
    private final int hash;

    public ComparableTree(@NotNull KtElement tree) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        this.tree = tree;
        this.hash = ComparableTree.Companion.computeHash(this.tree);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ComparableTree)) {
            return false;
        }
        return this.hash == ((ComparableTree)other).hash && SyntacticEquivalence.INSTANCE.areEquivalent(this.tree, ((ComparableTree)other).tree);
    }

    public int hashCode() {
        return this.hash;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00040\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/ComparableTree$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtElement;", "tree", "", "computeHash", "(Lorg/jetbrains/kotlin/psi/KtElement;)I", "", "contentHashCode", "(Ljava/util/List;)I"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final int computeHash(KtElement tree) {
            int n;
            void $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = tree.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            Object[] $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children2 = (List)destination$iv$iv;
            if (((Collection)children2).isEmpty()) {
                String string2 = tree.getText();
                Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
                n = ((Object)StringsKt.trim((CharSequence)string2)).toString().hashCode();
            } else {
                n = this.contentHashCode(children2);
            }
            return n;
        }

        private final int contentHashCode(List<? extends KtElement> $this$contentHashCode) {
            int hash = 0;
            hash = 7;
            Iterable $this$forEach$iv = $this$contentHashCode;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtElement it = (KtElement)element$iv;
                boolean bl = false;
                hash = 31 * hash + Companion.computeHash(it);
            }
            return hash;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

