/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.CoroutinesTimeoutApiUnusedCheckKt;

@Rule(key="S6316")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00188\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/sonarsource/kotlin/checks/CoroutinesTimeoutApiUnusedCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "asDelayCallIfMatching", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "targetInitializer", "asInitializerCallIfMatching", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)Lorg/jetbrains/kotlin/psi/KtExpression;", "", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class CoroutinesTimeoutApiUnusedCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(FunMatcherKt.FunMatcher$default(null, "cancel", null, "kotlinx.coroutines.Job", false, null, null, null, null, null, null, 2037, null));

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        SecondaryLocation[] secondaryLocationArray;
        KtReference ktReference;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u241 = kaSession;
        boolean bl = false;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression cancelCallCalleeExpression = ktExpression;
        PsiElement psiElement = callExpression.getContext();
        KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null || (psiElement = ktDotQualifiedExpression.getReceiverExpression()) == null || (ktReference = ReferenceUtilsKt.getMainReference((KtElement)psiElement)) == null || (secondaryLocationArray = $this$visitFunctionCall_u24lambda_u241.resolveToSymbol(ktReference)) == null) {
            return;
        }
        SecondaryLocation[] kaSymbol = secondaryLocationArray;
        PsiElement psiElement2 = callExpression.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
        Iterator<PsiElement> siblingIter = SequencesKt.filter(PsiUtilsKt.siblings(psiElement2, false, false), CoroutinesTimeoutApiUnusedCheck::visitFunctionCall$lambda$1$lambda$0).iterator();
        if (!siblingIter.hasNext()) {
            return;
        }
        KtExpression ktExpression2 = this.asDelayCallIfMatching(siblingIter.next());
        if (ktExpression2 == null) {
            return;
        }
        KtExpression delayCall = ktExpression2;
        KtExpression ktExpression3 = this.asInitializerCallIfMatching(siblingIter.next(), (KaSymbol)kaSymbol);
        if (ktExpression3 == null) {
            return;
        }
        KtExpression initializerCall = ktExpression3;
        secondaryLocationArray = new SecondaryLocation[]{new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, delayCall), null, 2, null), new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, initializerCall), null, 2, null)};
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)cancelCallCalleeExpression, "Use \"withTimeoutOrNull { }\" instead of manual delayed cancellation.", CollectionsKt.listOf(secondaryLocationArray), null, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtExpression asDelayCallIfMatching(PsiElement element) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$asDelayCallIfMatching_u24lambda_u242 = kaSession;
        boolean bl = false;
        if (!(element instanceof KtCallExpression)) return null;
        KaCallInfo kaCallInfo = $this$asDelayCallIfMatching_u24lambda_u242.resolveToCall((KtElement)element);
        if (!FunMatcherKt.matches((KaCallableMemberCall)(kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null), CoroutinesTimeoutApiUnusedCheckKt.access$getDELAY_MATCHER$p())) return null;
        KtExpression ktExpression = ((KtCallExpression)element).getCalleeExpression();
        return ktExpression;
    }

    private final KtExpression asInitializerCallIfMatching(PsiElement element, KaSymbol targetInitializer) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$asInitializerCallIfMatching_u24lambda_u243 = kaSession;
        boolean bl = false;
        if (element instanceof KtProperty && Intrinsics.areEqual($this$asInitializerCallIfMatching_u24lambda_u243.getSymbol((KtProperty)element), targetInitializer)) {
            KtExpression ktExpression = ((KtProperty)element).getInitializer();
            KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression initializer = ktCallExpression;
            KaCallInfo kaCallInfo = $this$asInitializerCallIfMatching_u24lambda_u243.resolveToCall(initializer);
            if (FunMatcherKt.matches((KaCallableMemberCall)(kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null), CoroutinesTimeoutApiUnusedCheckKt.access$getLAUNCH_ASYNC_MATCHER$p())) {
                return initializer.getCalleeExpression();
            }
        }
        return null;
    }

    private static final boolean visitFunctionCall$lambda$1$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtElement;
    }
}

