/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.DelegationPatternCheckKt;

@Rule(key="S6514")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/DelegationPatternCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classOrObject", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitClassOrObject", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "superInterfaces", "checkNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/Set;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class DelegationPatternCheck
extends AbstractCheck {
    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitClassOrObject_u24lambda_u241 = kaSession;
        boolean bl = false;
        KaClassSymbol kaClassSymbol = $this$visitClassOrObject_u24lambda_u241.getClassSymbol(classOrObject);
        if (kaClassSymbol == null) {
            return;
        }
        KaClassSymbol classSymbol = kaClassSymbol;
        if (classSymbol.getClassKind() == KaClassKind.INTERFACE) {
            return;
        }
        Set<KaClassSymbol> superInterfaces = DelegationPatternCheckKt.getSuperInterfaces(classSymbol);
        if (superInterfaces.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = classOrObject.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl2 = false;
            if (!(it instanceof KtNamedFunction)) continue;
            this.checkNamedFunction((KtNamedFunction)it, superInterfaces, context);
        }
    }

    private final void checkNamedFunction(KtNamedFunction function2, Set<? extends KaClassSymbol> superInterfaces, KotlinFileContext context) {
        boolean bl;
        block6: {
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$checkNamedFunction_u24lambda_u243 = kaSession;
            boolean bl2 = false;
            if (!KtPsiUtilKt.isPublic(function2) || !ApiExtensionsKt.overrides(function2)) {
                return;
            }
            Object object = DelegationPatternCheckKt.access$getDelegeeOrNull(function2);
            if (object == null || (object = $this$checkNamedFunction_u24lambda_u243.getExpressionType((KtExpression)object)) == null) {
                return;
            }
            Object delegeeType = object;
            Iterable $this$any$iv = DelegationPatternCheckKt.getCommonSuperInterfaces(superInterfaces, (KaType)delegeeType);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KaClassSymbol it = (KaClassSymbol)element$iv;
                    boolean bl3 = false;
                    if (!DelegationPatternCheckKt.access$isFunctionInInterface(function2, it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = function2.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, "Replace with interface delegation using \"by\" in the class header.", null, null, 12, null);
        }
    }
}

