/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.KtNamedFunctionsFinder;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S4144")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/DuplicatedFunctionImplementationCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "ctx", "", "visitKtFile", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDeclarations", "check", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Ljava/util/List;)V", "original", "duplicate", "reportDuplicate", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/jetbrains/kotlin/psi/KtNamedFunction;)V", "Companion"})
public final class DuplicatedFunctionImplementationCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BASE_MESSAGE = "Update this function so that its implementation is not identical to";
    private static final int MINIMUM_STATEMENTS_COUNT = 2;

    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext ctx) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        KtNamedFunctionsFinder functionsFinder = new KtNamedFunctionsFinder();
        file2.accept(functionsFinder);
        Map<PsiElement, List<KtNamedFunction>> $this$forEach$iv = functionsFinder.getFunctions();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PsiElement, List<KtNamedFunction>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<PsiElement, List<KtNamedFunction>> element$iv;
            Map.Entry<PsiElement, List<KtNamedFunction>> entry = element$iv = iterator2.next();
            boolean bl = false;
            List<KtNamedFunction> functions2 = entry.getValue();
            this.check(ctx, functions2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void check(KotlinFileContext ctx, List<? extends KtNamedFunction> functionDeclarations) {
        Set reportedDuplicates = new HashSet();
        Iterable $this$forEach$iv = CollectionsKt.getIndices((Collection)functionDeclarations);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$forEach$iv2;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            KtNamedFunction original = functionDeclarations.get(i);
            Sequence<KtNamedFunction> sequence2 = SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(SequencesKt.drop(CollectionsKt.asSequence((Iterable)functionDeclarations), i + 1), arg_0 -> DuplicatedFunctionImplementationCheck.check$lambda$5$lambda$1(reportedDuplicates, arg_0)), DuplicatedFunctionImplementationCheck::check$lambda$5$lambda$2), arg_0 -> DuplicatedFunctionImplementationCheck.check$lambda$5$lambda$3(original, arg_0));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KtNamedFunction duplicate = (KtNamedFunction)element$iv2;
                boolean bl2 = false;
                this.reportDuplicate(ctx, original, duplicate);
                reportedDuplicates.add(duplicate);
            }
        }
    }

    private final void reportDuplicate(KotlinFileContext ctx, KtNamedFunction original, KtNamedFunction duplicate) {
        Object object;
        TextRange textRange;
        block6: {
            int line;
            block5: {
                PsiElement psiElement = original.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = original;
                }
                textRange = KotlinTextRanges.INSTANCE.textRange(ctx, psiElement);
                line = textRange.start().line();
                object = original.getName();
                if (object == null) break block5;
                String it = object;
                boolean bl = false;
                String string2 = "Update this function so that its implementation is not identical to \"" + it + "\" on line " + line + ".";
                object = string2;
                if (string2 != null) break block6;
            }
            object = "Update this function so that its implementation is not identical to the one on line " + line + ".";
        }
        Object message = object;
        AbstractCheck abstractCheck = this;
        PsiElement psiElement = duplicate.getNameIdentifier();
        if (psiElement == null) {
            psiElement = duplicate;
        }
        AbstractCheck.reportIssue$default(abstractCheck, ctx, psiElement, (String)message, CollectionsKt.listOf(new SecondaryLocation(textRange, "original implementation")), null, 8, null);
    }

    private static final boolean check$lambda$5$lambda$1(Set $reportedDuplicates, KtNamedFunction f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return !$reportedDuplicates.contains(f);
    }

    private static final boolean check$lambda$5$lambda$2(KtNamedFunction f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return DuplicatedFunctionImplementationCheck.Companion.hasMinimumSize(f);
    }

    private static final boolean check$lambda$5$lambda$3(KtNamedFunction $original, KtNamedFunction f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return DuplicatedFunctionImplementationCheck.Companion.areDuplicatedImplementation($original, f);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/DuplicatedFunctionImplementationCheck$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "", "hasMinimumSize", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;)Z", "original", "possibleDuplicate", "areDuplicatedImplementation", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/jetbrains/kotlin/psi/KtNamedFunction;)Z", "", "BASE_MESSAGE", "Ljava/lang/String;", "", "MINIMUM_STATEMENTS_COUNT", "I"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasMinimumSize(KtNamedFunction function2) {
            Object object = function2.getBodyBlockExpression();
            if (object == null || (object = ((KtBlockExpression)object).getStatements()) == null) {
                return false;
            }
            Object statements = object;
            return statements.size() >= 2;
        }

        private final boolean areDuplicatedImplementation(KtNamedFunction original, KtNamedFunction possibleDuplicate) {
            return SyntacticEquivalence.INSTANCE.areEquivalent(original, possibleDuplicate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

