/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1186")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/EmptyFunctionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class EmptyFunctionCheck
extends AbstractCheck {
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtBlockExpression bodyBlockExpression = function2.getBodyBlockExpression();
        if (bodyBlockExpression != null && bodyBlockExpression.getStatements().isEmpty()) {
            PsiElement psiElement = function2.getLastChild();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getLastChild(...)");
            if (!this.hasComment(psiElement)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)bodyBlockExpression, "Add a nested comment explaining why this function is empty or complete the implementation.", null, null, 12, null);
            }
        }
    }
}

