/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\u0001\u001a\u0004\u0018\u00010\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0001\u0010\u0002\"\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n"}, d2={"", "getInsecureAlgorithmMessage", "(Ljava/lang/String;)Ljava/lang/String;", "Lkotlin/text/Regex;", "ALGORITHM_PATTERN", "Lkotlin/text/Regex;", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "CIPHER_GET_INSTANCE_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getCIPHER_GET_INSTANCE_MATCHER", "()Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;"})
public final class EncryptionAlgorithmCheckKt {
    @NotNull
    private static final Regex ALGORITHM_PATTERN = new Regex("([^/]+)/([^/]+)/([^/]+)");
    @NotNull
    private static final FunMatcherImpl CIPHER_GET_INSTANCE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, EncryptionAlgorithmCheckKt::CIPHER_GET_INSTANCE_MATCHER$lambda$0, 1023, null);

    @NotNull
    public static final FunMatcherImpl getCIPHER_GET_INSTANCE_MATCHER() {
        return CIPHER_GET_INSTANCE_MATCHER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getInsecureAlgorithmMessage(String $this$getInsecureAlgorithmMessage) {
        MatchResult matcher = ALGORITHM_PATTERN.matchEntire($this$getInsecureAlgorithmMessage);
        if (matcher == null) return "Use secure mode and padding scheme.";
        List<String> list = matcher.getGroupValues();
        if (list == null) return "Use secure mode and padding scheme.";
        List<String> list2 = list;
        boolean bl = false;
        String algorithm = list2.get(1);
        String mode = list2.get(2);
        String padding = list2.get(3);
        boolean isRSA = StringsKt.equals("RSA", algorithm, true);
        if (StringsKt.equals("ECB", mode, true) && !isRSA) {
            return "Use a secure cipher mode.";
        }
        if (StringsKt.equals("CBC", mode, true) && !StringsKt.equals("NoPadding", padding, true)) {
            return "Use another cipher mode or disable padding.";
        }
        if (!isRSA) return null;
        String string2 = padding.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        if (StringsKt.startsWith$default(string2, "OAEP", false, 2, null)) return null;
        return "Use a secure padding scheme.";
    }

    private static final Unit CIPHER_GET_INSTANCE_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("javax.crypto.Cipher");
        $this$FunMatcher.setName("getInstance");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getInsecureAlgorithmMessage(String $receiver) {
        return EncryptionAlgorithmCheckKt.getInsecureAlgorithmMessage($receiver);
    }
}

