/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.EqualsOverridenWithHashCodeCheckKt;

@Rule(key="S1206")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/EqualsOverridenWithHashCodeCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "klass", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "ctx", "", "visitClassBody", "(Lorg/jetbrains/kotlin/psi/KtClassBody;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class EqualsOverridenWithHashCodeCheck
extends AbstractCheck {
    @Override
    public void visitClassBody(@NotNull KtClassBody klass, @NotNull KotlinFileContext ctx) {
        block7: {
            KtNamedFunction it;
            Intrinsics.checkNotNullParameter(klass, "klass");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            KtNamedFunction equalsMethod = null;
            KtNamedFunction hashCodeMethod = null;
            Iterable $this$forEach$iv = klass.getFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction it2 = (KtNamedFunction)element$iv;
                boolean bl = false;
                if (hashCodeMethod == null && EqualsOverridenWithHashCodeCheckKt.access$getHashCodeMatcher$p().matches(it2)) {
                    hashCodeMethod = it2;
                } else if (equalsMethod == null && EqualsOverridenWithHashCodeCheckKt.access$getEqualsMatcher$p().matches(it2)) {
                    equalsMethod = it2;
                }
                if (hashCodeMethod == null || equalsMethod == null) continue;
                return;
            }
            KtNamedFunction ktNamedFunction = equalsMethod;
            if (ktNamedFunction != null) {
                it = ktNamedFunction;
                boolean bl = false;
                if (!ApiExtensionsKt.isAbstract(it)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)it, "This class overrides \"equals()\" and should therefore also override \"hashCode()\".", null, null, 12, null);
                }
            }
            KtNamedFunction ktNamedFunction2 = hashCodeMethod;
            if (ktNamedFunction2 == null) break block7;
            it = ktNamedFunction2;
            boolean bl = false;
            if (!ApiExtensionsKt.isAbstract(it)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)it, "This class overrides \"hashCode()\" and should therefore also override \"equals()\".", null, null, 12, null);
            }
        }
    }
}

