/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010*\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'2\u0006\u0010\t\u001a\u00020)H\u0002\u00a2\u0006\u0004\b*\u0010+R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0016\u0010-\u001a\u00020'8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020'8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010.R\u001a\u00102\u001a\b\u0012\u0004\u0012\u000201008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106"}, d2={"Lorg/sonarsource/kotlin/checks/FinallyBlockVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "report", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "expression", "visitLabeledExpression", "(Lorg/jetbrains/kotlin/psi/KtLabeledExpression;)V", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "finallySection", "visitFinallySection", "(Lorg/jetbrains/kotlin/psi/KtFinallySection;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "loopExpression", "visitLoopExpression", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;)V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;)V", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitBreakExpression", "(Lorg/jetbrains/kotlin/psi/KtBreakExpression;)V", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitContinueExpression", "(Lorg/jetbrains/kotlin/psi/KtContinueExpression;)V", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitReturnExpression", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;)V", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitThrowExpression", "(Lorg/jetbrains/kotlin/psi/KtThrowExpression;)V", "", "depthCounter", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "checkAndVisit", "(ILorg/jetbrains/kotlin/psi/KtExpressionWithLabel;)V", "Lkotlin/jvm/functions/Function1;", "loopDepthCounter", "I", "functionDepthCounter", "Ljava/util/Stack;", "", "stackedLabels", "Ljava/util/Stack;", "", "alreadyEnteredFinallyBlock", "Z"})
final class FinallyBlockVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Function1<KtExpression, Unit> report;
    private int loopDepthCounter;
    private int functionDepthCounter;
    @NotNull
    private final Stack<String> stackedLabels;
    private boolean alreadyEnteredFinallyBlock;

    public FinallyBlockVisitor(@NotNull Function1<? super KtExpression, Unit> report2) {
        Intrinsics.checkNotNullParameter(report2, "report");
        this.report = report2;
        this.stackedLabels = new Stack();
    }

    @Override
    public void visitLabeledExpression(@NotNull KtLabeledExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.stackedLabels.push(expression.getName());
        super.visitLabeledExpression(expression);
        this.stackedLabels.pop();
    }

    @Override
    public void visitFinallySection(@NotNull KtFinallySection finallySection) {
        Intrinsics.checkNotNullParameter(finallySection, "finallySection");
        if (!this.alreadyEnteredFinallyBlock) {
            this.alreadyEnteredFinallyBlock = true;
            super.visitFinallySection(finallySection);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.stackedLabels.push(expression.getFirstChild().getText());
        super.visitCallExpression(expression);
        this.stackedLabels.pop();
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        int n = this.loopDepthCounter;
        this.loopDepthCounter = n + 1;
        super.visitLoopExpression(loopExpression);
        n = this.loopDepthCounter;
        this.loopDepthCounter = n + -1;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        int n = this.functionDepthCounter;
        this.functionDepthCounter = n + 1;
        super.visitNamedFunction(function2);
        n = this.functionDepthCounter;
        this.functionDepthCounter = n + -1;
    }

    @Override
    public void visitBreakExpression(@NotNull KtBreakExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkAndVisit(this.loopDepthCounter, expression);
    }

    @Override
    public void visitContinueExpression(@NotNull KtContinueExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkAndVisit(this.loopDepthCounter, expression);
    }

    @Override
    public void visitReturnExpression(@NotNull KtReturnExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.checkAndVisit(this.functionDepthCounter, expression);
    }

    @Override
    public void visitThrowExpression(@NotNull KtThrowExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        if (this.functionDepthCounter == 0) {
            this.report.invoke(expression);
        }
    }

    private final void checkAndVisit(int depthCounter, KtExpressionWithLabel expression) {
        if (expression.getLabelQualifier() != null) {
            String string2 = expression.getLabelName();
            Intrinsics.checkNotNull(string2);
            if (!this.stackedLabels.contains(string2)) {
                this.report.invoke(expression);
            }
        } else if (depthCounter == 0) {
            this.report.invoke(expression);
        }
        this.visitExpressionWithLabel(expression);
    }
}

