/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.CognitiveComplexity;

@Rule(key="S3776")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "increment", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "secondaryLocation", "(Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "", "threshold", "I", "getThreshold", "()I", "setThreshold", "(I)V", "Companion"})
public final class FunctionCognitiveComplexityCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;
    private static final int DEFAULT_THRESHOLD = 15;

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = function2.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        CognitiveComplexity complexity = new CognitiveComplexity(function2);
        int value2 = complexity.value();
        if (value2 > this.threshold) {
            String string2 = "Refactor this method to reduce its Cognitive Complexity from " + value2 + " to the " + this.threshold + " allowed.";
            List<SecondaryLocation> list = complexity.increments().stream().map(arg_0 -> FunctionCognitiveComplexityCheck.visitNamedFunction$lambda$1(arg_0 -> FunctionCognitiveComplexityCheck.visitNamedFunction$lambda$0(this, context, arg_0), arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, "collect(...)");
            this.reportIssue(context, nameIdentifier, string2, list, (Double)((double)value2 - (double)this.threshold));
        }
    }

    private final SecondaryLocation secondaryLocation(CognitiveComplexity.Increment increment, KotlinFileContext context) {
        int nestingLevel = increment.getNestingLevel();
        String message = "+" + (nestingLevel + 1);
        if (nestingLevel > 0) {
            message = message + " (incl " + nestingLevel + " for nesting)";
        }
        TextRange textRange = KotlinTextRanges.INSTANCE.textRange(context, increment.getToken());
        return new SecondaryLocation(textRange, message);
    }

    private static final SecondaryLocation visitNamedFunction$lambda$0(FunctionCognitiveComplexityCheck this$0, KotlinFileContext $context, CognitiveComplexity.Increment increment) {
        Intrinsics.checkNotNullParameter(increment, "increment");
        return this$0.secondaryLocation(increment, $context);
    }

    private static final SecondaryLocation visitNamedFunction$lambda$1(Function1 $tmp0, Object p0) {
        return (SecondaryLocation)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck$Companion;", "", "<init>", "()V", "", "DEFAULT_THRESHOLD", "I"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

