/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a!\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\t\u0010\u0004\u001a\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u0004\u001a\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0004\u001a\u0017\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0004\"\u0014\u0010\u0011\u001a\u00020\u00008\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00008\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\"\u0014\u0010\u0014\u001a\u00020\u00008\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012\"\u0014\u0010\u0015\u001a\u00020\u00008\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0012\"\u0014\u0010\u0016\u001a\u00020\u00008\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0012\"\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\"\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\"\u0014\u0010\u001d\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0019\"\u0014\u0010\u001e\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0019\"\u0014\u0010\u001f\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0019\"\u0014\u0010 \u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u0019\"\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001c\"\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001c\"\u0014\u0010#\u001a\u00020\u00008\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b#\u0010\u0012"}, d2={"", "ip", "", "isValidIPV4", "(Ljava/lang/String;)Z", "ipv6", "ipv4", "isValidIPV6", "(Ljava/lang/String;Ljava/lang/String;)Z", "isIPV4Exception", "isIPV6Exception", "str", "", "getCompressionSeparatorCount", "(Ljava/lang/String;)I", "isReservedDocumentationIp", "isLocalIPv4MappedIPv6", "IPV4_ALONE", "Ljava/lang/String;", "IPV6_NO_PREFIX_COMPRESSION", "IPV6_PREFIX_COMPRESSION", "IPV6_ALONE", "IPV6_URL", "Lkotlin/text/Regex;", "IPV4_URL_REGEX", "Lkotlin/text/Regex;", "", "IPV6_REGEX_LIST", "Ljava/util/List;", "IPV6_LOOPBACK", "IPV6_NON_ROUTABLE", "INVALID_IPV4_PART_PATTERN", "IPV6_SPLIT_REGEX", "RESERVED_DOC_IP_RANGE", "LOCAL_IPV4_MAPPED_IPV6", "MESSAGE"})
public final class HardcodedIpCheckKt {
    @NotNull
    private static final String IPV4_ALONE = "(?<ipv4>(?:\\d{1,3}\\.){3}\\d{1,3})";
    @NotNull
    private static final String IPV6_NO_PREFIX_COMPRESSION = "(\\p{XDigit}{1,4}::?){1,7}\\p{XDigit}{1,4}(::)?";
    @NotNull
    private static final String IPV6_PREFIX_COMPRESSION = "::((\\p{XDigit}{1,4}:){0,6}\\p{XDigit}{1,4})?";
    @NotNull
    private static final String IPV6_ALONE = "(?<ipv6>((\\p{XDigit}{1,4}::?){1,7}\\p{XDigit}{1,4}(::)?|::((\\p{XDigit}{1,4}:){0,6}\\p{XDigit}{1,4})?)??(:?(?<ipv4>(?:\\d{1,3}\\.){3}\\d{1,3}))?)";
    @NotNull
    private static final String IPV6_URL = "([^\\d.]*/)?\\[(?<ipv6>((\\p{XDigit}{1,4}::?){1,7}\\p{XDigit}{1,4}(::)?|::((\\p{XDigit}{1,4}:){0,6}\\p{XDigit}{1,4})?)??(:?(?<ipv4>(?:\\d{1,3}\\.){3}\\d{1,3}))?)]((:\\d{1,5})?(?!\\d|\\.))(/.*)?";
    @NotNull
    private static final Regex IPV4_URL_REGEX = new Regex("([^\\d.]*/)?(?<ipv4>(?:\\d{1,3}\\.){3}\\d{1,3})((:\\d{1,5})?(?!\\d|\\.))(/.*)?");
    @NotNull
    private static final List<Regex> IPV6_REGEX_LIST;
    @NotNull
    private static final Regex IPV6_LOOPBACK;
    @NotNull
    private static final Regex IPV6_NON_ROUTABLE;
    @NotNull
    private static final Regex INVALID_IPV4_PART_PATTERN;
    @NotNull
    private static final Regex IPV6_SPLIT_REGEX;
    @NotNull
    private static final List<String> RESERVED_DOC_IP_RANGE;
    @NotNull
    private static final List<String> LOCAL_IPV4_MAPPED_IPV6;
    @NotNull
    private static final String MESSAGE = "Make sure using this hardcoded IP address is safe here.";

    private static final boolean isValidIPV4(String ip) {
        boolean bl;
        block1: {
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)ip, stringArray, false, 0, 6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] $this$none$iv = thisCollection$iv.toArray(new String[0]);
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$none$iv[i];
                boolean bl2 = false;
                if (!(INVALID_IPV4_PART_PATTERN.matches(it) || Integer.valueOf(it) > 255)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean isValidIPV6(String ipv6, String ipv4) {
        CharSequence charSequence = ipv6;
        Regex regex = IPV6_SPLIT_REGEX;
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        int partCount = split.length;
        int compressionSeparatorCount = HardcodedIpCheckKt.getCompressionSeparatorCount(ipv6);
        boolean validUncompressed = false;
        boolean validCompressed = false;
        if (ipv4 != null) {
            boolean hasValidIPV4 = HardcodedIpCheckKt.isValidIPV4(ipv4);
            validUncompressed = hasValidIPV4 && compressionSeparatorCount == 0 && partCount == 7;
            validCompressed = hasValidIPV4 && compressionSeparatorCount == 1 && partCount <= 6;
        } else {
            validUncompressed = compressionSeparatorCount == 0 && partCount == 8;
            validCompressed = compressionSeparatorCount == 1 && partCount <= 7;
        }
        return validUncompressed || validCompressed;
    }

    private static final boolean isIPV4Exception(String ip) {
        return StringsKt.startsWith$default(ip, "127.", false, 2, null) || Intrinsics.areEqual("255.255.255.255", ip) || Intrinsics.areEqual("0.0.0.0", ip) || StringsKt.startsWith$default(ip, "2.5.", false, 2, null) || HardcodedIpCheckKt.isReservedDocumentationIp(ip) || HardcodedIpCheckKt.isLocalIPv4MappedIPv6(ip);
    }

    private static final boolean isIPV6Exception(String ip) {
        return IPV6_LOOPBACK.matches(ip) || IPV6_NON_ROUTABLE.matches(ip) || HardcodedIpCheckKt.isReservedDocumentationIp(ip) || HardcodedIpCheckKt.isLocalIPv4MappedIPv6(ip);
    }

    private static final int getCompressionSeparatorCount(String str) {
        String[] stringArray = new String[]{"::"};
        return StringsKt.split$default((CharSequence)str, stringArray, false, 0, 6, null).size() - 1;
    }

    private static final boolean isReservedDocumentationIp(String ip) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = RESERVED_DOC_IP_RANGE;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(ip, it, false, 2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isLocalIPv4MappedIPv6(String ip) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = LOCAL_IPV4_MAPPED_IPV6;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith(ip, it, true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Regex access$getIPV4_URL_REGEX$p() {
        return IPV4_URL_REGEX;
    }

    public static final /* synthetic */ boolean access$isValidIPV4(String ip) {
        return HardcodedIpCheckKt.isValidIPV4(ip);
    }

    public static final /* synthetic */ boolean access$isIPV4Exception(String ip) {
        return HardcodedIpCheckKt.isIPV4Exception(ip);
    }

    public static final /* synthetic */ List access$getIPV6_REGEX_LIST$p() {
        return IPV6_REGEX_LIST;
    }

    public static final /* synthetic */ boolean access$isValidIPV6(String ipv6, String ipv4) {
        return HardcodedIpCheckKt.isValidIPV6(ipv6, ipv4);
    }

    public static final /* synthetic */ boolean access$isIPV6Exception(String ip) {
        return HardcodedIpCheckKt.isIPV6Exception(ip);
    }

    static {
        Object[] objectArray = new Regex[]{new Regex(IPV6_ALONE), new Regex(IPV6_URL)};
        IPV6_REGEX_LIST = CollectionsKt.listOf(objectArray);
        IPV6_LOOPBACK = new Regex("[0:]++0*+1");
        IPV6_NON_ROUTABLE = new Regex("[0:]++");
        INVALID_IPV4_PART_PATTERN = new Regex("^0\\d{1,2}");
        IPV6_SPLIT_REGEX = new Regex("::?");
        objectArray = new String[]{"192.0.2.", "198.51.100.", "203.0.113.", "2001:db8:"};
        RESERVED_DOC_IP_RANGE = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"::ffff:0:127.", "::ffff:127."};
        LOCAL_IPV4_MAPPED_IPV6 = CollectionsKt.listOf(objectArray);
    }
}

