/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S1764")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/IdenticalBinaryOperandCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Companion"})
public final class IdenticalBinaryOperandCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<KtSingleValueToken> OPERATORS;

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtSingleValueToken token = expression.getOperationReference().getOperationSignTokenType();
        KtExpression ktExpression = expression.getRight();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression rightOperand = ktExpression;
        KtExpression ktExpression2 = expression.getLeft();
        Intrinsics.checkNotNull(ktExpression2);
        KtExpression leftOperand = ktExpression2;
        if (OPERATORS.contains(token) && SyntacticEquivalence.INSTANCE.areEquivalent(leftOperand, rightOperand)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)rightOperand, "Correct one of the identical sub-expressions on both sides this operator.", CollectionsKt.listOf(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(context, leftOperand), "")), null, 8, null);
        }
    }

    static {
        KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.OROR, KtTokens.ANDAND, KtTokens.MINUS, KtTokens.DIV, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ};
        OPERATORS = SetsKt.setOf(ktSingleValueTokenArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0006\u001a\f\u0012\b\u0012\u0006*\u00020\u00050\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/sonarsource/kotlin/checks/IdenticalBinaryOperandCheck$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "OPERATORS", "Ljava/util/Set;", "getOPERATORS", "()Ljava/util/Set;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<KtSingleValueToken> getOPERATORS() {
            return OPERATORS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

