/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1145")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\r*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0013\u0010\u0011\u001a\u00020\r*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\r*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000fJ/\u0010\u0017\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/sonarsource/kotlin/checks/IfConditionalAlwaysTrueOrFalseCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "condition", "", "isAlwaysTrueOrFalse", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "isTrueValueLiteral", "isFalseValueLiteral", "isNegation", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "operation", "Lkotlin/Function1;", "hasLiteralValue", "isSimpleExpressionWithLiteral", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;Lkotlin/jvm/functions/Function1;)Z", "isSimpleExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)Z"})
public final class IfConditionalAlwaysTrueOrFalseCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtExpression ktExpression = expression.getCondition();
        Intrinsics.checkNotNull(ktExpression);
        if (this.isAlwaysTrueOrFalse(ktExpression)) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression2 = expression.getCondition();
            Intrinsics.checkNotNull(ktExpression2);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression2, "Remove this useless \"if\" statement.", null, null, 12, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAlwaysTrueOrFalse(KtExpression condition) {
        if (this.isTrueValueLiteral(condition)) return true;
        if (this.isFalseValueLiteral(condition)) return true;
        KtSingleValueToken ktSingleValueToken = KtTokens.ANDAND;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "ANDAND");
        if (this.isSimpleExpressionWithLiteral(condition, ktSingleValueToken, arg_0 -> IfConditionalAlwaysTrueOrFalseCheck.isAlwaysTrueOrFalse$lambda$0(this, arg_0))) return true;
        KtSingleValueToken ktSingleValueToken2 = KtTokens.OROR;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken2, "OROR");
        if (!this.isSimpleExpressionWithLiteral(condition, ktSingleValueToken2, arg_0 -> IfConditionalAlwaysTrueOrFalseCheck.isAlwaysTrueOrFalse$lambda$1(this, arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrueValueLiteral(KtExpression $this$isTrueValueLiteral) {
        KtExpression e = this.skipParentheses($this$isTrueValueLiteral);
        if (e instanceof KtConstantExpression) {
            if (Intrinsics.areEqual(((KtConstantExpression)e).getText(), "true")) return true;
        }
        if (!this.isNegation(e)) return false;
        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtUnaryExpression");
        KtExpression ktExpression = ((KtUnaryExpression)e).getBaseExpression();
        Intrinsics.checkNotNull(ktExpression);
        if (!this.isFalseValueLiteral(ktExpression)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFalseValueLiteral(KtExpression $this$isFalseValueLiteral) {
        KtExpression e = this.skipParentheses($this$isFalseValueLiteral);
        if (e instanceof KtConstantExpression) {
            if (Intrinsics.areEqual(((KtConstantExpression)e).getText(), "false")) return true;
        }
        if (!this.isNegation(e)) return false;
        Intrinsics.checkNotNull(e, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtUnaryExpression");
        KtExpression ktExpression = ((KtUnaryExpression)e).getBaseExpression();
        Intrinsics.checkNotNull(ktExpression);
        if (!this.isTrueValueLiteral(ktExpression)) return false;
        return true;
    }

    private final boolean isNegation(KtExpression $this$isNegation) {
        return $this$isNegation instanceof KtUnaryExpression && Intrinsics.areEqual(((KtUnaryExpression)$this$isNegation).getOperationToken(), KtTokens.EXCL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleExpressionWithLiteral(KtExpression $this$isSimpleExpressionWithLiteral, KtSingleValueToken operation, Function1<? super KtExpression, Boolean> hasLiteralValue) {
        if (!this.isSimpleExpression($this$isSimpleExpressionWithLiteral, operation)) return false;
        PsiElement $this$anyDescendantOfType$iv = $this$isSimpleExpressionWithLiteral;
        boolean $i$f$anyDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText($this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(hasLiteralValue, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimpleExpression(KtExpression $this$isSimpleExpression, KtSingleValueToken operation) {
        KtExpression e = this.skipParentheses($this$isSimpleExpression);
        if (e instanceof KtNameReferenceExpression) {
            return true;
        }
        if (e instanceof KtConstantExpression) {
            return true;
        }
        if (!(e instanceof KtBinaryExpression)) return false;
        if (!Intrinsics.areEqual(((KtBinaryExpression)e).getOperationToken(), operation)) return false;
        KtExpression ktExpression = ((KtBinaryExpression)e).getLeft();
        Intrinsics.checkNotNull(ktExpression);
        if (!this.isSimpleExpression(ktExpression, operation)) return false;
        KtExpression ktExpression2 = ((KtBinaryExpression)e).getRight();
        Intrinsics.checkNotNull(ktExpression2);
        if (!this.isSimpleExpression(ktExpression2, operation)) return false;
        return true;
    }

    private static final boolean isAlwaysTrueOrFalse$lambda$0(IfConditionalAlwaysTrueOrFalseCheck this$0, KtExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isFalseValueLiteral(it);
    }

    private static final boolean isAlwaysTrueOrFalse$lambda$1(IfConditionalAlwaysTrueOrFalseCheck this$0, KtExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isTrueValueLiteral(it);
    }
}

