/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.CommonConstantsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S6310")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/InjectableDispatchersCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/name/ClassId;", "dispatchersClassId", "Lorg/jetbrains/kotlin/name/ClassId;"})
public final class InjectableDispatchersCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CommonConstantsKt.getFUNS_ACCEPTING_DISPATCHERS();
    @NotNull
    private final ClassId dispatchersClassId = ClassId.Companion.fromString$default(ClassId.Companion, StringsKt.replace$default("kotlinx.coroutines.Dispatchers", '.', '/', false, 4, null), false, 2, null);

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u240 = kaSession;
        boolean bl = false;
        KtExpression ktExpression = (KtExpression)CollectionsKt.firstOrNull((Iterable)resolvedCall2.getArgumentMapping().keySet());
        if (ktExpression == null) {
            return;
        }
        KtExpression argExpr = ktExpression;
        KtExpression ktExpression2 = ApiExtensionsKt.predictRuntimeValueExpression$default(argExpr, null, 1, null);
        KtQualifiedExpression ktQualifiedExpression = ktExpression2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)ktExpression2 : null;
        if (ktQualifiedExpression == null) {
            return;
        }
        KtQualifiedExpression argValueExpr = ktQualifiedExpression;
        KaLifetimeOwner kaLifetimeOwner = $this$visitFunctionCall_u24lambda_u240.resolveToCall(argValueExpr);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulVariableAccessCall((KaCallInfo)kaLifetimeOwner)) == null) {
            return;
        }
        KaLifetimeOwner variableAccessCall = kaLifetimeOwner;
        KaLifetimeOwner kaLifetimeOwner2 = variableAccessCall.getPartiallyAppliedSymbol().getDispatchReceiver();
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = kaLifetimeOwner2.getType()) == null) {
            return;
        }
        KaLifetimeOwner receiver = kaLifetimeOwner2;
        if ($this$visitFunctionCall_u24lambda_u240.isClassType((KaType)receiver, this.dispatchersClassId)) {
            List secondaries = argExpr != argValueExpr ? CollectionsKt.listOf(KotlinFileContextKt.secondaryOf(kotlinFileContext, argValueExpr, "Hard-coded dispatcher")) : CollectionsKt.emptyList();
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)argExpr, "Avoid hardcoded dispatchers.", secondaries, null, 8, null);
        }
    }
}

