/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.IsInstanceMethodCheckKt;

@Rule(key="S6202")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\u00020\u00142\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u001c\u001a\u00020\u000f*\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR \u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#"}, d2={"Lorg/sonarsource/kotlin/checks/IsInstanceMethodCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lcom/intellij/psi/PsiElement;", "ctx", "", "onlyClass", "", "qualifiedName", "(Lcom/intellij/psi/PsiElement;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Z)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "qualifiedNameWithoutJavaClassKeyword", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Z)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expr", "isJavaClassKeyword", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "isClass", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;)Z", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class IsInstanceMethodCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public IsInstanceMethodCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("kotlin.reflect.KClass", "isInstance", null, null, false, null, null, null, null, null, IsInstanceMethodCheck::functionsToVisit$lambda$0, 1020, null), FunMatcherKt.FunMatcher$default("java.lang.Class", "isInstance", null, null, false, null, null, null, null, null, IsInstanceMethodCheck::functionsToVisit$lambda$1, 1020, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        block0: {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression);
            String string2 = this.qualifiedName(ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null, kotlinFileContext, true);
            if (string2 == null) break block0;
            String className = string2;
            boolean bl = false;
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Replace this usage of \"isInstance\" with \"is " + className + "\".", null, null, 12, null);
        }
    }

    private final String qualifiedName(PsiElement $this$qualifiedName, KotlinFileContext ctx, boolean onlyClass) {
        Object object;
        KtExpression expr = KtPsiUtil.deparenthesize($this$qualifiedName instanceof KtExpression ? (KtExpression)$this$qualifiedName : null);
        if (expr instanceof KtClassLiteralExpression) {
            object = onlyClass ? this.qualifiedName(((KtClassLiteralExpression)expr).getLhs(), ctx, true) : null;
        } else if (expr instanceof KtNameReferenceExpression) {
            object = !onlyClass || this.isClass((KtReferenceExpression)expr) ? ((KtNameReferenceExpression)expr).getReferencedName() : null;
        } else if (expr instanceof KtDotQualifiedExpression) {
            String right = this.qualifiedName(((KtDotQualifiedExpression)expr).getSelectorExpression(), ctx, onlyClass);
            if (right != null) {
                String string2 = this.qualifiedName(((KtDotQualifiedExpression)expr).getReceiverExpression(), ctx, false);
                if (string2 != null) {
                    String left = string2;
                    boolean bl = false;
                    object = left + "." + right;
                } else {
                    object = null;
                }
            } else {
                object = this.qualifiedNameWithoutJavaClassKeyword((KtDotQualifiedExpression)expr, ctx, onlyClass);
            }
        } else {
            object = null;
        }
        return object;
    }

    private final String qualifiedNameWithoutJavaClassKeyword(KtDotQualifiedExpression $this$qualifiedNameWithoutJavaClassKeyword, KotlinFileContext ctx, boolean onlyClass) {
        return onlyClass && this.isJavaClassKeyword($this$qualifiedNameWithoutJavaClassKeyword.getSelectorExpression()) ? this.qualifiedName($this$qualifiedNameWithoutJavaClassKeyword.getReceiverExpression(), ctx, true) : null;
    }

    private final boolean isJavaClassKeyword(KtExpression expr) {
        return expr instanceof KtNameReferenceExpression && IsInstanceMethodCheckKt.access$getJAVA_CLASS_KEYWORDS$p().contains(((KtNameReferenceExpression)expr).getReferencedName());
    }

    private final boolean isClass(KtReferenceExpression $this$isClass) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$isClass_u24lambda_u244 = kaSession;
        boolean bl = false;
        return $this$isClass_u24lambda_u244.resolveToSymbol(ReferenceUtilsKt.getMainReference($this$isClass)) instanceof KaClassSymbol;
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Any"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Any"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }
}

