/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.LiftReturnStatementCheckKt;

@Rule(key="S6510")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/LiftReturnStatementCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhenExpression", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lcom/intellij/psi/PsiElement;", "keywordElement", "reportIssue", "(Lcom/intellij/psi/PsiElement;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class LiftReturnStatementCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtExpression ktExpression = expression.getThen();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression thenBranch = ktExpression;
        KtExpression ktExpression2 = expression.getElse();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression elseBranch = ktExpression2;
        if (LiftReturnStatementCheckKt.access$isReturnOrReturnBlock(thenBranch) && LiftReturnStatementCheckKt.access$isReturnOrReturnBlock(elseBranch)) {
            PsiElement psiElement = expression.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
            this.reportIssue(psiElement, context);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull KotlinFileContext context) {
        boolean isAllBranchesReturn;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            List<KtWhenEntry> list = expression.getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv;
                    boolean bl2 = false;
                    KtExpression ktExpression = it.getExpression();
                    Intrinsics.checkNotNull(ktExpression);
                    if (LiftReturnStatementCheckKt.access$isReturnOrReturnBlock(ktExpression)) continue;
                    bl = false;
                    break block4;
                }
                bl = isAllBranchesReturn = true;
            }
        }
        if (isAllBranchesReturn && ApiExtensionsKt.isExhaustive(expression)) {
            PsiElement psiElement = expression.getWhenKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
            this.reportIssue(psiElement, context);
        }
    }

    private final void reportIssue(PsiElement keywordElement, KotlinFileContext context) {
        Intrinsics.checkNotNull(keywordElement, "null cannot be cast to non-null type com.intellij.psi.impl.source.tree.LeafPsiElement");
        CharSequence charSequence = ((LeafPsiElement)keywordElement).getChars();
        Intrinsics.checkNotNullExpressionValue(charSequence, "getChars(...)");
        CharSequence keyword = charSequence;
        AbstractCheck.reportIssue$default((AbstractCheck)this, context, keywordElement, "Move \"return\" statements from all branches before \"" + keyword + "\" statement.", null, null, 12, null);
    }
}

