/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.MergeIfElseIntoWhenCheckKt;

@Rule(key="S6511")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/MergeIfElseIntoWhenCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitIfExpression", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "threshold", "I", "getThreshold", "()I", "setThreshold", "(I)V"})
public final class MergeIfElseIntoWhenCheck
extends AbstractCheck {
    @RuleProperty(key="threshold", description="Number of \"if\" after which the chain should be replaced by a \"when\" statement.", defaultValue="3")
    private int threshold = 3;

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        if (!MergeIfElseIntoWhenCheckKt.access$isElseElement(psiElement) && MergeIfElseIntoWhenCheckKt.access$isIfChainLongerThanOrEqualThreshold(expression, this.threshold)) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AbstractCheck abstractCheck = this;
            PsiElement psiElement2 = expression.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getIfKeyword(...)");
            Iterable iterable = MergeIfElseIntoWhenCheckKt.access$collectSecondaryIfStatements(expression);
            String string2 = "Merge chained \"if\" statements into a single \"when\" statement.";
            PsiElement psiElement3 = psiElement2;
            KotlinFileContext kotlinFileContext = context;
            AbstractCheck abstractCheck2 = abstractCheck;
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtIfExpression ktIfExpression = (KtIfExpression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PsiElement psiElement4 = it.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement4, "getIfKeyword(...)");
                collection.add(KotlinFileContextKt.secondaryOf(context, psiElement4, "Merge with first \"if\" statement."));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck2, kotlinFileContext, psiElement3, string2, (List)collection, null, 8, null);
        }
    }
}

