/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.MobileDatabaseEncryptionKeysCheckKt;

@Rule(key="S6301")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/MobileDatabaseEncryptionKeysCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class MobileDatabaseEncryptionKeysCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public MobileDatabaseEncryptionKeysCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.ConstructorMatcher$default("net.sqlcipher.database.SQLiteDatabase", null, 2, null), FunMatcherKt.FunMatcher$default("net.sqlcipher.database.SQLiteDatabase", null, null, null, false, null, null, null, null, null, MobileDatabaseEncryptionKeysCheck::functionsToVisit$lambda$0, 1022, null), FunMatcherKt.FunMatcher$default("io.realm.RealmConfiguration.Builder", "encryptionKey", null, null, false, null, null, null, null, null, null, 2044, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        List secondaries;
        Object object;
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KaFunctionSymbol symbol = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(resolvedCall2.getPartiallyAppliedSymbol());
        if (symbol instanceof KaConstructorSymbol) {
            object = "<init>";
        } else {
            object = KaSymbolKt.getName(symbol);
            if (object == null || (object = ((Name)object).asString()) == null) {
                return;
            }
        }
        String functionName = object;
        List valueArgumentsList = CollectionsKt.toList((Iterable)resolvedCall2.getArgumentMapping().keySet());
        if (valueArgumentsList.size() < 2 && !Intrinsics.areEqual(functionName, "encryptionKey")) {
            return;
        }
        String[] stringArray = new String[]{"encryptionKey", "changePassword"};
        KtExpression arg = SetsKt.setOf(stringArray).contains(functionName) ? (KtExpression)valueArgumentsList.get(0) : (KtExpression)valueArgumentsList.get(1);
        KtExpression argValueExpr = ApiExtensionsKt.predictRuntimeValueExpression(arg, secondaries = (List)new ArrayList());
        if (MobileDatabaseEncryptionKeysCheckKt.access$isHardCoded(argValueExpr, secondaries)) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String parameter = Intrinsics.areEqual(functionName, "encryptionKey") ? "encryptionKey" : "password";
            Iterable iterable = secondaries;
            String string2 = "The \"" + parameter + "\" parameter should not be hardcoded.";
            PsiElement psiElement = arg;
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck = this;
            boolean $i$f$map = false;
            void var13_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiElement psiElement2 = (PsiElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)it), null, 2, null));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext2, psiElement, string2, (List)collection, null, 8, null);
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"changePassword", "openDatabase", "openOrCreateDatabase", "create"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

