/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\"\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\t\"\u0014\u0010\u000b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\t\"\u0014\u0010\f\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\t"}, d2={"Lorg/jetbrains/kotlin/psi/KtCallExpression;", "", "isChainedMethodInvocation", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Z", "", "MESSAGE", "Ljava/lang/String;", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "MATH_RANDOM_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "KOTLIN_RANDOM_MATCHER", "RANDOM_TYPES_MATCHER", "RANDOM_CONSTRUCTORS_MATCHER"})
public final class PseudoRandomCheckKt {
    @NotNull
    private static final String MESSAGE = "Make sure that using this pseudorandom number generator is safe here.";
    @NotNull
    private static final FunMatcherImpl MATH_RANDOM_MATCHER = FunMatcherKt.FunMatcher$default("java.lang.Math", "random", null, null, false, null, null, null, null, null, PseudoRandomCheckKt::MATH_RANDOM_MATCHER$lambda$0, 1020, null);
    @NotNull
    private static final FunMatcherImpl KOTLIN_RANDOM_MATCHER = FunMatcherKt.FunMatcher$default("kotlin.random", "Random", null, null, false, null, null, null, null, null, null, 2044, null);
    @NotNull
    private static final FunMatcherImpl RANDOM_TYPES_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, PseudoRandomCheckKt::RANDOM_TYPES_MATCHER$lambda$1, 1023, null);
    @NotNull
    private static final FunMatcherImpl RANDOM_CONSTRUCTORS_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, true, null, null, null, null, null, PseudoRandomCheckKt::RANDOM_CONSTRUCTORS_MATCHER$lambda$2, 1007, null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isChainedMethodInvocation(KtCallExpression $this$isChainedMethodInvocation) {
        PsiElement psiElement = $this$isChainedMethodInvocation.getParent();
        if (psiElement == null) return false;
        PsiElement it = psiElement;
        boolean bl = false;
        if (!(it instanceof KtDotQualifiedExpression)) return false;
        if (!(((KtDotQualifiedExpression)it).getReceiverExpression() instanceof KtDotQualifiedExpression)) return false;
        KtExpression ktExpression = ((KtDotQualifiedExpression)it).getReceiverExpression();
        Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
        if (!(((KtDotQualifiedExpression)ktExpression).getSelectorExpression() instanceof KtCallExpression)) return false;
        return true;
    }

    private static final Unit MATH_RANDOM_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit RANDOM_TYPES_MATCHER$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"java.util.concurrent.ThreadLocalRandom", "org.apache.commons.lang.math.RandomUtils", "org.apache.commons.lang3.RandomUtils", "org.apache.commons.lang.RandomStringUtils", "org.apache.commons.lang3.RandomStringUtils"};
        $this$FunMatcher.setQualifiers(SetsKt.setOf(stringArray));
        return Unit.INSTANCE;
    }

    private static final Unit RANDOM_CONSTRUCTORS_MATCHER$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"java.util.Random", "org.apache.commons.lang.math.JVMRandom"};
        $this$FunMatcher.setQualifiers(SetsKt.setOf(stringArray));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FunMatcherImpl access$getMATH_RANDOM_MATCHER$p() {
        return MATH_RANDOM_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getKOTLIN_RANDOM_MATCHER$p() {
        return KOTLIN_RANDOM_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getRANDOM_TYPES_MATCHER$p() {
        return RANDOM_TYPES_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getRANDOM_CONSTRUCTORS_MATCHER$p() {
        return RANDOM_CONSTRUCTORS_MATCHER;
    }

    public static final /* synthetic */ boolean access$isChainedMethodInvocation(KtCallExpression $receiver) {
        return PseudoRandomCheckKt.isChainedMethodInvocation($receiver);
    }
}

