/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S6516")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/SamConversionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "declaration", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitObjectDeclaration", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class SamConversionCheck
extends AbstractCheck {
    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitObjectDeclaration_u24lambda_u240 = kaSession;
        boolean bl = false;
        KtSuperTypeListEntry ktSuperTypeListEntry = CollectionsKt.singleOrNull(declaration.getSuperTypeListEntries());
        if (ktSuperTypeListEntry == null) {
            return;
        }
        KtSuperTypeListEntry superTypeEntry = ktSuperTypeListEntry;
        KtTypeReference ktTypeReference = superTypeEntry.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        if (($this$visitObjectDeclaration_u24lambda_u240.isFunctionalInterface($this$visitObjectDeclaration_u24lambda_u240.getType(typeReference)) || $this$visitObjectDeclaration_u24lambda_u240.getFunctionTypeKind($this$visitObjectDeclaration_u24lambda_u240.getType(typeReference)) != null) && ApiExtensionsKt.hasExactlyOneFunctionAndNoProperties(declaration)) {
            PsiElement psiElement = declaration.getDeclarationKeyword();
            Intrinsics.checkNotNull(psiElement);
            TextRange textRange = ApiExtensionsKt.merge(context, psiElement, superTypeEntry);
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, textRange, "Replace explicit functional interface implementation with lambda expression.", null, null, 12, null);
        }
    }
}

