/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S1656")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/SelfAssignmentCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class SelfAssignmentCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ)) {
            KtExpression ktExpression = expression.getLeft();
            Intrinsics.checkNotNull(ktExpression);
            PsiElement psiElement = ktExpression;
            KtExpression ktExpression2 = expression.getRight();
            Intrinsics.checkNotNull(ktExpression2);
            if (SyntacticEquivalence.INSTANCE.areEquivalent(psiElement, ktExpression2)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)expression, "Remove or correct this useless self-assignment.", null, null, 12, null);
            }
        }
    }
}

