/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.SimplifySizeExpressionCheckKt;

@Rule(key="S6529")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J9\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b \u0010!J1\u0010\"\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\"\u0010#R \u0010%\u001a\b\u0012\u0004\u0012\u00020\b0$8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010("}, d2={"Lorg/sonarsource/kotlin/checks/SimplifySizeExpressionCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "expression", "visitReferenceExpression", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkSizeTest", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "isIsEmpty", "checkIsEmptyTest", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;ZLorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lcom/intellij/psi/PsiElement;", "sizeTest", "useIsEmpty", "doReportSize", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "sizeTestQualifier", "checkNullTestOrReportSize", "(Lcom/intellij/psi/PsiElement;ZZLorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "checkNullTest", "(Lcom/intellij/psi/PsiElement;ZLorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)Z", "", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class SimplifySizeExpressionCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public SimplifySizeExpressionCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{SimplifySizeExpressionCheckKt.access$getCountMatcher$p(), SimplifySizeExpressionCheckKt.access$isEmptyMatcher$p(), SimplifySizeExpressionCheckKt.access$isNotEmptyMatcher$p()};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (Intrinsics.areEqual(matchedFun, SimplifySizeExpressionCheckKt.access$getCountMatcher$p())) {
            this.checkSizeTest(callExpression, kotlinFileContext);
        } else {
            this.checkIsEmptyTest(callExpression, Intrinsics.areEqual(matchedFun, SimplifySizeExpressionCheckKt.access$isEmptyMatcher$p()), kotlinFileContext);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull KtReferenceExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        block2: {
            block3: {
                Intrinsics.checkNotNullParameter(expression, "expression");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                boolean $i$f$withKaSession = false;
                KaSession kaSession = KotlinFileVisitorKt.getKaSession();
                Intrinsics.checkNotNull(kaSession);
                KaSession $this$visitReferenceExpression_u24lambda_u240 = kaSession;
                boolean bl = false;
                if (!(expression instanceof KtNameReferenceExpression)) break block2;
                KaCallInfo kaCallInfo = $this$visitReferenceExpression_u24lambda_u240.resolveToCall(expression);
                if (SimplifySizeExpressionCheckKt.access$getSizeMatcher$p().matches(kaCallInfo != null ? KaCallInfoKt.successfulVariableAccessCall(kaCallInfo) : null)) break block3;
                KaCallInfo kaCallInfo2 = $this$visitReferenceExpression_u24lambda_u240.resolveToCall(expression);
                if (!SimplifySizeExpressionCheckKt.access$getLengthMatcher$p().matches(kaCallInfo2 != null ? KaCallInfoKt.successfulVariableAccessCall(kaCallInfo2) : null)) break block2;
            }
            this.checkSizeTest(expression, kotlinFileContext);
        }
    }

    private final void checkSizeTest(KtExpression expression, KotlinFileContext kotlinFileContext) {
        block11: {
            PsiElement psiElement;
            boolean isSizeEquals;
            KtBinaryExpression sizeTest;
            block10: {
                boolean bl;
                Integer operationTokenId;
                Integer n;
                PsiElement psiElement2 = expression.getParent();
                Intrinsics.checkNotNullExpressionValue(psiElement2, "getParent(...)");
                PsiElement psiElement3 = this.skipParentParentheses(SimplifySizeExpressionCheckKt.access$expandOptionalQualifier(psiElement2));
                KtBinaryExpression ktBinaryExpression = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
                if (ktBinaryExpression == null) {
                    return;
                }
                sizeTest = ktBinaryExpression;
                Integer n2 = n = (operationTokenId = SimplifySizeExpressionCheckKt.access$getOperationTokenId(sizeTest));
                int n3 = 71;
                if (n2 != null && n2 == n3) {
                    bl = true;
                } else {
                    Integer n4 = n;
                    n3 = 72;
                    if (n4 == null || n4 != n3) {
                        Integer n5 = n;
                        n3 = 64;
                        if (n5 == null || n5 != n3) {
                            Integer n6 = n;
                            n3 = 63;
                            if (n6 == null || n6 != n3) {
                                return;
                            }
                        }
                    }
                    bl = false;
                }
                isSizeEquals = bl;
                Integer n7 = operationTokenId;
                int n8 = 63;
                if ((n7 == null || n7 != n8) && SimplifySizeExpressionCheckKt.access$isIntZeroLiteral(sizeTest.getRight())) break block10;
                Integer n9 = operationTokenId;
                n8 = 64;
                if (n9 != null && n9 == n8 || !SimplifySizeExpressionCheckKt.access$isIntZeroLiteral(sizeTest.getLeft())) break block11;
            }
            this.checkNullTestOrReportSize(sizeTest, isSizeEquals, true, (psiElement = expression.getParent()) instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null, kotlinFileContext);
        }
    }

    private final void checkIsEmptyTest(KtCallExpression expression, boolean isIsEmpty, KotlinFileContext kotlinFileContext) {
        boolean bl;
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        PsiElement psiElement2 = this.skipParentParentheses(SimplifySizeExpressionCheckKt.access$expandOptionalQualifier(psiElement));
        if (psiElement2 == null) {
            return;
        }
        PsiElement isEmptyTest = psiElement2;
        if (isEmptyTest instanceof KtPrefixExpression) {
            Integer operationTokenId;
            Integer n = operationTokenId = SimplifySizeExpressionCheckKt.access$getOperationTokenId((KtExpression)isEmptyTest);
            int n2 = 60;
            bl = n != null && n == n2;
        } else {
            PsiElement endExclusive = isEmptyTest;
            isEmptyTest = expression;
            while (!Intrinsics.areEqual(isEmptyTest.getParent(), endExclusive)) {
                Intrinsics.checkNotNullExpressionValue(isEmptyTest.getParent(), "getParent(...)");
            }
            bl = false;
        }
        boolean isNegated = bl;
        PsiElement psiElement3 = expression.getParent();
        this.checkNullTestOrReportSize(isEmptyTest, isIsEmpty != isNegated, isNegated, psiElement3 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement3 : null, kotlinFileContext);
    }

    private final void checkNullTestOrReportSize(PsiElement sizeTest, boolean useIsEmpty, boolean doReportSize, KtDotQualifiedExpression sizeTestQualifier, KotlinFileContext kotlinFileContext) {
        if (this.checkNullTest(sizeTest, useIsEmpty, sizeTestQualifier, kotlinFileContext) || !doReportSize) {
            return;
        }
        String replaceFunction = useIsEmpty ? "isEmpty()" : "isNotEmpty()";
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, sizeTest, "Replace collection size check with \"" + replaceFunction + "\"", null, null, 12, null);
    }

    private final boolean checkNullTest(PsiElement sizeTest, boolean useIsEmpty, KtDotQualifiedExpression sizeTestQualifier, KotlinFileContext kotlinFileContext) {
        boolean bl;
        boolean bl2;
        KtDotQualifiedExpression ktDotQualifiedExpression = sizeTestQualifier;
        KtExpression ktExpression = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null;
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression sizeTestReceiver = ktNameReferenceExpression;
        Object object = this.skipParentParentheses(sizeTest.getParent());
        KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression connectorExpression = ktBinaryExpression;
        Object object2 = object = SimplifySizeExpressionCheckKt.access$getOperationTokenId(connectorExpression);
        int n = 74;
        if (object2 != null && (Integer)object2 == n) {
            bl2 = false;
        } else {
            Object object3 = object;
            n = 76;
            if (object3 != null && (Integer)object3 == n) {
                bl2 = true;
            } else {
                return false;
            }
        }
        boolean isOrConnector = bl2;
        if (isOrConnector != useIsEmpty) {
            return false;
        }
        KtExpression ktExpression2 = connectorExpression.getLeft();
        Object object4 = ktExpression2 != null ? this.skipParentheses(ktExpression2) : null;
        KtBinaryExpression ktBinaryExpression2 = object4 instanceof KtBinaryExpression ? (KtBinaryExpression)object4 : null;
        if (ktBinaryExpression2 == null) {
            return false;
        }
        KtBinaryExpression nullTest = ktBinaryExpression2;
        Object object5 = object4 = SimplifySizeExpressionCheckKt.access$getOperationTokenId(nullTest);
        int n2 = 71;
        if (object5 != null && (Integer)object5 == n2) {
            bl = true;
        } else {
            Object object6 = object4;
            n2 = 72;
            if (object6 != null && (Integer)object6 == n2) {
                bl = false;
            } else {
                return false;
            }
        }
        boolean isEqualsNull = bl;
        if (isEqualsNull != useIsEmpty) {
            return false;
        }
        KtNameReferenceExpression ktNameReferenceExpression2 = SimplifySizeExpressionCheckKt.access$getNullTestReference(nullTest);
        if (!Intrinsics.areEqual(ktNameReferenceExpression2 != null ? ktNameReferenceExpression2.getReferencedName() : null, sizeTestReceiver.getReferencedName())) {
            return false;
        }
        String replaceFunction = useIsEmpty ? "isNullOrEmpty()" : "!isNullOrEmpty()";
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)connectorExpression, "Replace null check and collection size check with \"" + replaceFunction + "\"", null, null, 12, null);
        return true;
    }
}

