/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.api.visiting.KtTreeVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\fR&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\r8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/SingleConstructorCallExtractor;", "Lorg/sonarsource/kotlin/api/visiting/KtTreeVisitor;", "", "", "singletonClassCandidates", "<init>", "(Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "Ljava/util/Set;", "", "singleConstructorCallByClass", "Ljava/util/Map;", "getSingleConstructorCallByClass", "()Ljava/util/Map;", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "constructorMatcher", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;"})
final class SingleConstructorCallExtractor
extends KtTreeVisitor {
    @NotNull
    private final Set<String> singletonClassCandidates;
    @NotNull
    private final Map<String, KtCallExpression> singleConstructorCallByClass;
    @NotNull
    private FunMatcherImpl constructorMatcher;

    public SingleConstructorCallExtractor(@NotNull Set<String> singletonClassCandidates) {
        Intrinsics.checkNotNullParameter(singletonClassCandidates, "singletonClassCandidates");
        this.singletonClassCandidates = singletonClassCandidates;
        this.singleConstructorCallByClass = new LinkedHashMap();
        this.constructorMatcher = FunMatcherKt.ConstructorMatcher$default(null, arg_0 -> SingleConstructorCallExtractor.constructorMatcher$lambda$0(this, arg_0), 1, null);
    }

    @NotNull
    public final Map<String, KtCallExpression> getSingleConstructorCallByClass() {
        return this.singleConstructorCallByClass;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        block3: {
            KaPartiallyAppliedSymbol kaPartiallyAppliedSymbol;
            KaFunctionCall<?> kaFunctionCall;
            Intrinsics.checkNotNullParameter(expression, "expression");
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$visitCallExpression_u24lambda_u243 = kaSession;
            boolean bl = false;
            if (this.singletonClassCandidates.isEmpty() || !this.constructorMatcher.matches(expression)) {
                return;
            }
            KaCallInfo kaCallInfo = $this$visitCallExpression_u24lambda_u243.resolveToCall(expression);
            KaFunctionSymbol kaFunctionSymbol = kaCallInfo != null && (kaFunctionCall = KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo)) != null && (kaPartiallyAppliedSymbol = kaFunctionCall.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaPartiallyAppliedSymbol) : null;
            KaConstructorSymbol kaConstructorSymbol = kaFunctionSymbol instanceof KaConstructorSymbol ? (KaConstructorSymbol)kaFunctionSymbol : null;
            if (kaConstructorSymbol == null) {
                return;
            }
            KaConstructorSymbol kaConstructorSymbol2 = kaConstructorSymbol;
            Object object = kaConstructorSymbol2.getContainingClassId();
            if (object == null || (object = ((ClassId)object).asFqNameString()) == null) {
                return;
            }
            Object fqName2 = object;
            KtCallExpression ktCallExpression = this.singleConstructorCallByClass.put((String)fqName2, expression);
            if (ktCallExpression == null) break block3;
            KtCallExpression it = ktCallExpression;
            boolean bl2 = false;
            this.singleConstructorCallByClass.remove(fqName2);
            this.singletonClassCandidates.remove(fqName2);
            this.constructorMatcher = FunMatcherKt.ConstructorMatcher$default(null, arg_0 -> SingleConstructorCallExtractor.visitCallExpression$lambda$3$lambda$2$lambda$1(this, arg_0), 1, null);
        }
    }

    private static final Unit constructorMatcher$lambda$0(SingleConstructorCallExtractor this$0, FunMatcherBuilderContext $this$ConstructorMatcher) {
        Intrinsics.checkNotNullParameter($this$ConstructorMatcher, "$this$ConstructorMatcher");
        Collection $this$toTypedArray$iv = this$0.singletonClassCandidates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        $this$ConstructorMatcher.withTypeNames(Arrays.copyOf(stringArray, stringArray.length));
        return Unit.INSTANCE;
    }

    private static final Unit visitCallExpression$lambda$3$lambda$2$lambda$1(SingleConstructorCallExtractor this$0, FunMatcherBuilderContext $this$ConstructorMatcher) {
        Intrinsics.checkNotNullParameter($this$ConstructorMatcher, "$this$ConstructorMatcher");
        Collection $this$toTypedArray$iv = this$0.singletonClassCandidates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        $this$ConstructorMatcher.withTypeNames(Arrays.copyOf(stringArray, stringArray.length));
        return Unit.INSTANCE;
    }
}

