/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.StreamNotConsumedCheckKt;

@Rule(key="S3958")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/StreamNotConsumedCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class StreamNotConsumedCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public StreamNotConsumedCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{StreamNotConsumedCheckKt.access$getSEQUENCE_MATCHER$p(), FunMatcherKt.FunMatcher$default(null, null, null, "kotlin.collections.List", false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$0, 1015, null), FunMatcherKt.FunMatcher$default("java.util.stream.Stream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$1, 1022, null), FunMatcherKt.FunMatcher$default("java.util.stream.IntStream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$2, 1022, null), FunMatcherKt.FunMatcher$default("java.util.stream.LongStream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$3, 1022, null), FunMatcherKt.FunMatcher$default("java.util.stream.DoubleStream", null, null, null, false, null, null, null, null, null, StreamNotConsumedCheck::functionsToVisit$lambda$4, 1022, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u245 = kaSession;
        boolean bl = false;
        if (!$this$visitFunctionCall_u24lambda_u245.isUsedAsExpression(callExpression)) {
            String message = Intrinsics.areEqual(matchedFun, StreamNotConsumedCheckKt.access$getSEQUENCE_MATCHER$p()) ? "Refactor the code so this sequence pipeline is used." : "Refactor the code so this stream pipeline is used.";
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, message, null, null, 12, null);
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"parallelStream", "stream"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"flatMapToDouble", "flatMapToInt", "flatMapToLong", "mapToDouble", "mapToInt", "mapToLong"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_PRIMITIVE_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"asDoubleStream", "asLongStream", "mapToDouble", "mapToLong"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_PRIMITIVE_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"asDoubleStream", "mapToDouble", "mapToInt"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$4(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = StreamNotConsumedCheckKt.access$getCOMMON_PRIMITIVE_STREAM_NON_TERM$p();
        $this$FunMatcher.withNames(Arrays.copyOf(stringArray, stringArray.length));
        stringArray = new String[]{"mapToInt", "mapToLong"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

