/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.StrongCipherAlgorithmCheckKt;

@Rule(key="S5547")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/StrongCipherAlgorithmCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpr", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class StrongCipherAlgorithmCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpr, @NotNull KotlinFileContext kotlinFileContext) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(callExpr, "callExpr");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                if (!StrongCipherAlgorithmCheckKt.access$getNullCipherConstructorMatcher$p().matches(callExpr)) break block8;
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callExpr, "Use a strong cipher algorithm.", null, null, 12, null);
                break block9;
            }
            if (!StrongCipherAlgorithmCheckKt.access$getCipherGetInstanceMatcher$p().matches(callExpr)) break block9;
            List<KtValueArgument> list = callExpr.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
            KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list);
            if (ktValueArgument != null) {
                KtValueArgument arg = ktValueArgument;
                boolean bl = false;
                Object object = arg.getArgumentExpression();
                if (object != null && (object = ApiExtensionsKt.predictRuntimeStringValue((KtExpression)object)) != null) {
                    String string2 = ((String)object).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                    object = string2;
                    if (string2 != null) {
                        boolean bl2;
                        block7: {
                            Object candidateString = object;
                            boolean bl3 = false;
                            Iterable $this$any$iv = StrongCipherAlgorithmCheckKt.access$getWeakCiphers$p();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    String cipher = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!(Intrinsics.areEqual(candidateString, cipher) || StringsKt.startsWith$default((String)candidateString, cipher + "/", false, 2, null))) continue;
                                    bl2 = true;
                                    break block7;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)arg, "Use a strong cipher algorithm.", null, null, 12, null);
                        }
                    }
                }
            }
        }
    }
}

