/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.CommonConstantsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.StructuredConcurrencyPrinciplesCheckKt;

@Rule(key="S6306")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/StructuredConcurrencyPrinciplesCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "matchedFun", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class StructuredConcurrencyPrinciplesCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CommonConstantsKt.getFUNS_ACCEPTING_DISPATCHERS();

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        KtNameReferenceExpression receiver;
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtExpression ktExpression = ApiExtensionsKt.predictReceiverExpression(callExpression);
        KtNameReferenceExpression ktNameReferenceExpression = receiver = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (Intrinsics.areEqual(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null, "GlobalScope") && !StructuredConcurrencyPrinciplesCheckKt.access$checkOptInDelicateApi(callExpression)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)receiver, "Using \"GlobalScope\" here leads to the breaking of structured concurrency principles.", null, null, 12, null);
        } else {
            Object t = CollectionsKt.firstOrNull((Iterable)resolvedCall2.getArgumentMapping().keySet());
            KtCallExpression ktCallExpression = t instanceof KtCallExpression ? (KtCallExpression)t : null;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression argExprCall = ktCallExpression;
            if (StructuredConcurrencyPrinciplesCheckKt.access$getJOB_CONSTRUCTOR$p().matches(argExprCall) || StructuredConcurrencyPrinciplesCheckKt.access$getSUPERVISOR_JOB_CONSTRUCTOR$p().matches(argExprCall)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)argExprCall, "Using \"" + argExprCall.getText() + "\" here leads to the breaking of structured concurrency principles.", null, null, 12, null);
            }
        }
    }
}

