/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.sonarsource.kotlin.checks.ComparableTree;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\t\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000bJ)\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/SyntacticEquivalence;", "", "<init>", "()V", "", "Lcom/intellij/psi/PsiElement;", "first", "second", "", "areEquivalent", "(Ljava/util/Iterator;Ljava/util/Iterator;)Z", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Z", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "list", "findDuplicatedGroups", "(Ljava/util/List;)Ljava/util/List;"})
public final class SyntacticEquivalence {
    @NotNull
    public static final SyntacticEquivalence INSTANCE = new SyntacticEquivalence();

    private SyntacticEquivalence() {
    }

    private final boolean areEquivalent(Iterator<? extends PsiElement> first2, Iterator<? extends PsiElement> second2) {
        Iterator<? extends PsiElement> firstIterator = first2;
        Iterator<? extends PsiElement> secondIterator = second2;
        while (firstIterator.hasNext() && secondIterator.hasNext()) {
            if (this.areEquivalent(firstIterator.next(), secondIterator.next())) continue;
            return false;
        }
        return !firstIterator.hasNext() && !secondIterator.hasNext();
    }

    public final boolean areEquivalent(@NotNull PsiElement first2, @NotNull PsiElement second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        if (first2 == second2) {
            return true;
        }
        if (!Intrinsics.areEqual(first2.getClass(), second2.getClass())) {
            return false;
        }
        PsiElement[] psiElementArray = first2.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        Iterator<PsiElement> leftChildrenIterator = SequencesKt.filter(ArraysKt.asSequence((Object[])psiElementArray), SyntacticEquivalence::areEquivalent$lambda$0).iterator();
        PsiElement[] psiElementArray2 = second2.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray2, "getChildren(...)");
        Iterator<PsiElement> rightChildrenIterator = SequencesKt.filter(ArraysKt.asSequence((Object[])psiElementArray2), SyntacticEquivalence::areEquivalent$lambda$1).iterator();
        if (!leftChildrenIterator.hasNext() && !rightChildrenIterator.hasNext()) {
            return Intrinsics.areEqual(first2.getText(), second2.getText());
        }
        return this.areEquivalent(leftChildrenIterator, rightChildrenIterator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<KtElement>> findDuplicatedGroups(@NotNull List<? extends KtElement> list) {
        void $this$filterTo$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KtElement p0 = (KtElement)element$iv$iv;
            boolean bl = false;
            ComparableTree key$iv$iv = new ComparableTree(p0);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List group = (List)element$iv$iv;
            boolean bl = false;
            if (!(group.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean areEquivalent$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtElement;
    }

    private static final boolean areEquivalent$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtElement;
    }
}

