/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1067")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/sonarsource/kotlin/checks/TooComplexExpressionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "isParentExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)Z", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "computeExpressionComplexity", "(Lorg/jetbrains/kotlin/psi/KtExpression;)I", "max", "I", "getMax", "()I", "setMax", "(I)V", "Companion"})
public final class TooComplexExpressionCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="max", description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    private int max = 3;
    private static final int DEFAULT_MAX_COMPLEXITY = 3;

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.isParentExpression(expression)) {
            return;
        }
        int complexity = this.computeExpressionComplexity(expression);
        if (complexity > this.max) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression, "Reduce the number of conditional operators (" + complexity + ") used in the expression (maximum allowed " + this.max + ").", null, (Double)((double)complexity - (double)this.max), 4, null);
        }
    }

    private final boolean isParentExpression(KtBinaryExpression expression) {
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParents(expression).iterator();
        while (iterator2.hasNext()) {
            PsiElement parent2 = iterator2.next();
            if (parent2 instanceof KtBinaryExpression) {
                return false;
            }
            if (parent2 instanceof KtUnaryExpression && parent2 instanceof KtParenthesizedExpression) continue;
            return true;
        }
        return true;
    }

    private final int computeExpressionComplexity(KtExpression expression) {
        int n;
        KtExpression e = this.skipParentheses(expression);
        if (e instanceof KtBinaryExpression) {
            KtSingleValueToken operator = ((KtBinaryExpression)e).getOperationReference().getOperationSignTokenType();
            int complexity = Intrinsics.areEqual(operator, KtTokens.OROR) || Intrinsics.areEqual(operator, KtTokens.ANDAND) ? 1 : 0;
            KtExpression ktExpression = ((KtBinaryExpression)e).getLeft();
            Intrinsics.checkNotNull(ktExpression);
            int n2 = complexity + this.computeExpressionComplexity(ktExpression);
            KtExpression ktExpression2 = ((KtBinaryExpression)e).getRight();
            Intrinsics.checkNotNull(ktExpression2);
            n = n2 + this.computeExpressionComplexity(ktExpression2);
        } else if (e instanceof KtUnaryExpression) {
            KtExpression ktExpression = ((KtUnaryExpression)e).getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            n = this.computeExpressionComplexity(ktExpression);
        } else {
            n = 0;
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/TooComplexExpressionCheck$Companion;", "", "<init>", "()V", "", "DEFAULT_MAX_COMPLEXITY", "I"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

