/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.AbstractTooLongFunctionRule;

@Rule(key="S5612")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0017X\u0097D\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLambdaCheck;", "Lorg/sonarsource/kotlin/checks/AbstractTooLongFunctionRule;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "expression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitLambdaExpression", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "max", "I", "getMax", "()I", "setMax", "(I)V", "", "elementName", "Ljava/lang/String;", "getElementName", "()Ljava/lang/String;"})
public final class TooLongLambdaCheck
extends AbstractTooLongFunctionRule {
    @RuleProperty(key="max", description="Maximum authorized lines of code in a lambda expression", defaultValue="20")
    private int max = 20;
    @NotNull
    private final String elementName;

    public TooLongLambdaCheck() {
        this.elementName = "lambda";
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMax(int n) {
        this.max = n;
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtFunctionLiteral ktFunctionLiteral = expression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
        this.check(ktFunctionLiteral, kotlinFileContext);
    }
}

