/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;

@Rule(key="S107")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyParametersCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "type", "visitFunctionType", "(Lorg/jetbrains/kotlin/psi/KtFunctionType;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lcom/intellij/psi/PsiElement;", "reportingLocation", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "parameters", "report", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "max", "I", "getMax", "()I", "setMax", "(I)V", "", "exceptionsList", "Ljava/util/List;", "Companion"})
public final class TooManyParametersCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="Max", description="Maximum authorized number of parameters", defaultValue="7")
    private int max = 7;
    @NotNull
    private final List<String> exceptionsList;
    public static final int DEFAULT_MAX = 7;

    public TooManyParametersCheck() {
        String[] stringArray = new String[]{"RequestMapping", "GetMapping", "PostMapping", "PutMapping", "DeleteMapping", "PatchMapping", "JsonCreator"};
        this.exceptionsList = CollectionsKt.listOf(stringArray);
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (function2.getValueParameters().size() > this.max && !function2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            boolean bl;
            block6: {
                List<KtAnnotationEntry> list = function2.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        Name name = it.getShortName();
                        if (!CollectionsKt.contains((Iterable)this.exceptionsList, name != null ? name.asString() : null)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                List<KtParameter> list = function2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                this.report(psiElement, list, kotlinFileContext);
            }
        }
    }

    @Override
    public void visitFunctionType(@NotNull KtFunctionType type2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (type2.getParameters().size() > this.max) {
            PsiElement psiElement = type2;
            List<KtParameter> list = type2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
            this.report(psiElement, list, kotlinFileContext);
        }
    }

    private final void report(PsiElement reportingLocation, List<? extends KtParameter> parameters2, KotlinFileContext kotlinFileContext) {
        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, reportingLocation, "This function has " + parameters2.size() + " parameters, which is greater than the " + this.max + " authorized.", SequencesKt.toList(SequencesKt.map(SequencesKt.drop(CollectionsKt.asSequence((Iterable)parameters2), this.max), arg_0 -> TooManyParametersCheck.report$lambda$1(kotlinFileContext, arg_0))), null, 8, null);
    }

    private static final SecondaryLocation report$lambda$1(KotlinFileContext $kotlinFileContext, KtParameter it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange($kotlinFileContext, it), null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyParametersCheck$Companion;", "", "<init>", "()V", "", "DEFAULT_MAX", "I"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

