/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S6300")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/UnencryptedFilesInMobileApplicationsCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "functionsToVisit", "Ljava/util/Set;", "getFunctionsToVisit", "()Ljava/util/Set;"})
public final class UnencryptedFilesInMobileApplicationsCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit;

    public UnencryptedFilesInMobileApplicationsCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("kotlin.io", null, null, null, false, null, null, null, null, null, UnencryptedFilesInMobileApplicationsCheck::functionsToVisit$lambda$0, 1022, null), FunMatcherKt.ConstructorMatcher$default("java.io.FileOutputStream", null, 2, null), FunMatcherKt.ConstructorMatcher$default("java.io.FileWriter", null, 2, null), FunMatcherKt.FunMatcher$default("java.nio.file.Files", "write", null, null, false, null, null, null, null, null, null, 2044, null)};
        this.functionsToVisit = SetsKt.setOf(funMatcherImplArray);
    }

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (this.isInAndroid(kotlinFileContext)) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Make sure using unencrypted files is safe here.", null, null, 12, null);
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"writeText", "appendBytes"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }
}

