/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaImportOptimizerResult;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.UnnecessaryImportsCheckKt;

@Rule(key="S1128")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/sonarsource/kotlin/checks/UnnecessaryImportsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "context", "", "visitKtFile", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V"})
public final class UnnecessaryImportsCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitKtFile_u24lambda_u248 = kaSession;
        boolean bl = false;
        KaImportOptimizerResult importOptimizer = $this$visitKtFile_u24lambda_u248.analyzeImportsToOptimize(file2);
        Sequence<KtImportDirective> $this$forEach$iv = SequencesKt.map(SequencesKt.filter(SequencesKt.mapNotNull(SequencesKt.filter(CollectionsKt.asSequence((Iterable)file2.getImportDirectives()), arg_0 -> UnnecessaryImportsCheck.visitKtFile$lambda$8$lambda$1(file2, this, context, arg_0)), UnnecessaryImportsCheck::visitKtFile$lambda$8$lambda$3), arg_0 -> UnnecessaryImportsCheck.visitKtFile$lambda$8$lambda$4(importOptimizer, arg_0)), UnnecessaryImportsCheck::visitKtFile$lambda$8$lambda$5);
        boolean $i$f$forEach = false;
        Iterator<KtImportDirective> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            KtExpression it;
            KtImportDirective element$iv;
            KtImportDirective importDirective = element$iv = iterator2.next();
            boolean bl2 = false;
            if (importDirective.getImportedReference() == null) continue;
            boolean bl3 = false;
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)it, "Remove this unused import.", null, null, 12, null);
        }
    }

    private static final boolean visitKtFile$lambda$8$lambda$1(KtFile $file, UnnecessaryImportsCheck this$0, KotlinFileContext $context, KtImportDirective importDirective) {
        boolean bl;
        Intrinsics.checkNotNullParameter(importDirective, "importDirective");
        KtPackageDirective ktPackageDirective = $file.getPackageDirective();
        if (UnnecessaryImportsCheckKt.access$isImportedImplicitlyAlready(importDirective, ktPackageDirective != null ? ktPackageDirective.getQualifiedName() : null)) {
            KtExpression ktExpression = importDirective.getImportedReference();
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl2 = false;
                AbstractCheck.reportIssue$default((AbstractCheck)this$0, $context, (PsiElement)it, "Remove this redundant import.", null, null, 12, null);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final Pair visitKtFile$lambda$8$lambda$3(KtImportDirective importDirective) {
        Pair<KtImportDirective, FqName> pair;
        Intrinsics.checkNotNullParameter(importDirective, "importDirective");
        FqName fqName2 = importDirective.getImportedFqName();
        if (fqName2 != null) {
            FqName it = fqName2;
            boolean bl = false;
            pair = TuplesKt.to(importDirective, it);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final boolean visitKtFile$lambda$8$lambda$4(KaImportOptimizerResult $importOptimizer, Pair pair) {
        Collection collection;
        Name importedName;
        Name name;
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        KtImportDirective importDirective = (KtImportDirective)pair.component1();
        FqName importedFqName = (FqName)pair.component2();
        if (importDirective.isAllUnder()) {
            return false;
        }
        if (importDirective.getAliasName() != null) {
            String string2 = importDirective.getAliasName();
            Intrinsics.checkNotNull(string2);
            Name name2 = Name.identifier(string2);
            name = name2;
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        } else {
            name = importedName = importedFqName.shortName();
        }
        return !$importOptimizer.getUnresolvedNames().contains(importedName) && !OperatorConventions.isConventionName(importedName) && !Intrinsics.areEqual(importedName.asString(), "provideDelegate") && ((collection = (Collection)$importOptimizer.getUsedDeclarations().get(importedFqName)) == null || collection.isEmpty());
    }

    private static final KtImportDirective visitKtFile$lambda$8$lambda$5(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (KtImportDirective)it.getFirst();
    }
}

