/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.ArgumentMatcher;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.CommonConstantsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S4347")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/UnpredictableSecureRandomSaltCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "resolvedCall", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitFunctionCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "functionsToVisit", "Ljava/util/List;", "getFunctionsToVisit", "()Ljava/util/List;"})
public final class UnpredictableSecureRandomSaltCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public UnpredictableSecureRandomSaltCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("java.security.SecureRandom", "setSeed", null, null, false, null, null, null, null, null, null, 2044, null), FunMatcherKt.ConstructorMatcher("java.security.SecureRandom", UnpredictableSecureRandomSaltCheck::functionsToVisit$lambda$0)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitFunctionCall_u24lambda_u241 = kaSession;
        boolean bl = false;
        KtExpression ktExpression = (KtExpression)CollectionsKt.firstOrNull((Iterable)resolvedCall2.getArgumentMapping().keySet());
        if (ktExpression != null) {
            KtExpression saltArg = ktExpression;
            KtExpression predictedSaltValue = ApiExtensionsKt.predictRuntimeValueExpression$default(saltArg, null, 1, null);
            if (predictedSaltValue instanceof KtConstantExpression || ApiExtensionsKt.isBytesInitializedFromString(predictedSaltValue)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Change this seed value to something unpredictable, or remove the seed.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf$default(kotlinFileContext, predictedSaltValue, null, 2, null)), null, 8, null);
            } else {
                KaCallableMemberCall kaCallableMemberCall;
                FunMatcherImpl funMatcherImpl = CommonConstantsKt.getBYTE_ARRAY_CONSTRUCTOR_SIZE_ARG_ONLY();
                KaCallInfo kaCallInfo = $this$visitFunctionCall_u24lambda_u241.resolveToCall(predictedSaltValue);
                if (kaCallInfo != null) {
                    Object v4;
                    FunMatcherImpl funMatcherImpl2;
                    block8: {
                        void $this$singleCallOrNull$iv;
                        KaCallInfo kaCallInfo2 = kaCallInfo;
                        funMatcherImpl2 = funMatcherImpl;
                        boolean $i$f$singleCallOrNull = false;
                        Iterable $this$singleOrNull$iv$iv = KaCallInfoKt.getCalls((KaCallInfo)$this$singleCallOrNull$iv);
                        boolean $i$f$singleOrNull = false;
                        Object single$iv$iv = null;
                        boolean found$iv$iv = false;
                        for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                            KaCall it$iv = (KaCall)element$iv$iv;
                            boolean bl2 = false;
                            if (!(it$iv instanceof KaCallableMemberCall)) continue;
                            if (found$iv$iv) {
                                v4 = null;
                                break block8;
                            }
                            single$iv$iv = element$iv$iv;
                            found$iv$iv = true;
                        }
                        v4 = !found$iv$iv ? null : single$iv$iv;
                    }
                    funMatcherImpl = funMatcherImpl2;
                    kaCallableMemberCall = (KaCallableMemberCall)((KaCall)v4);
                } else {
                    kaCallableMemberCall = null;
                }
                if (funMatcherImpl.matches(kaCallableMemberCall) && ApiExtensionsKt.isInitializedPredictably(saltArg, predictedSaltValue)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Change this seed value to something unpredictable, or remove the seed.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf$default(kotlinFileContext, predictedSaltValue, null, 2, null)), null, 8, null);
                }
            }
        }
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$ConstructorMatcher) {
        Intrinsics.checkNotNullParameter($this$ConstructorMatcher, "$this$ConstructorMatcher");
        ArgumentMatcher[] argumentMatcherArray = new ArgumentMatcher[]{ArgumentMatcher.Companion.getANY()};
        $this$ConstructorMatcher.withArguments(argumentMatcherArray);
        return Unit.INSTANCE;
    }
}

