/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.UselessNullCheckCheckKt;

@Rule(key="S6619")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJC\u0010#\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\b0 H\u0002\u00a2\u0006\u0004\b#\u0010$"}, d2={"Lorg/sonarsource/kotlin/checks/UselessNullCheckCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "binaryExpression", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "kotlinFileContext", "", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "safeDotExpression", "kfc", "visitSafeQualifiedExpression", "(Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "unaryExpression", "visitUnaryExpression", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callExpression", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "operandComparedToNull", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lcom/intellij/psi/PsiElement;", "issueLocation", "", "comparesToNull", "Lkotlin/Function1;", "Lorg/sonarsource/kotlin/api/reporting/Message;", "nullCheckTypeForMessage", "raiseIssueIfUselessCheck", "(Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/PsiElement;ZLkotlin/jvm/functions/Function1;)V"})
public final class UselessNullCheckCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(binaryExpression, "binaryExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        IElementType iElementType = binaryExpression.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.raiseIssueIfUselessCheck(kotlinFileContext, it, binaryExpression, true, UselessNullCheckCheck::visitBinaryExpression$lambda$1$lambda$0);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.raiseIssueIfUselessCheck(kotlinFileContext, it, binaryExpression, false, UselessNullCheckCheck::visitBinaryExpression$lambda$3$lambda$2);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.ELVIS)) {
            KtExpression ktExpression = binaryExpression.getLeft();
            Intrinsics.checkNotNull(ktExpression);
            KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            this.raiseIssueIfUselessCheck(kotlinFileContext, ktExpression, ktOperationReferenceExpression, false, UselessNullCheckCheck::visitBinaryExpression$lambda$4);
        }
    }

    @Override
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression safeDotExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(safeDotExpression, "safeDotExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        KtExpression ktExpression = safeDotExpression.getReceiverExpression();
        PsiElement psiElement = safeDotExpression.getOperationTokenNode().getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        this.raiseIssueIfUselessCheck(kfc, ktExpression, psiElement, false, UselessNullCheckCheck::visitSafeQualifiedExpression$lambda$5);
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression unaryExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(unaryExpression, "unaryExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        if (Intrinsics.areEqual(unaryExpression.getOperationToken(), KtTokens.EXCLEXCL)) {
            KtExpression ktExpression = unaryExpression.getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            KtSimpleNameExpression ktSimpleNameExpression = unaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
            this.raiseIssueIfUselessCheck(kfc, ktExpression, ktSimpleNameExpression, false, UselessNullCheckCheck::visitUnaryExpression$lambda$6);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitCallExpression_u24lambda_u247 = kaSession;
        boolean bl = false;
        KaCallInfo kaCallInfo = $this$visitCallExpression_u24lambda_u247.resolveToCall(callExpression);
        KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
        if (kaFunctionCall == null) {
            return;
        }
        KaFunctionCall<?> resolvedCall2 = kaFunctionCall;
        if (FunMatcherKt.matches((KaCallableMemberCall)resolvedCall2, UselessNullCheckCheckKt.access$getNON_NULL_CHECK_FUNS$p())) {
            KtExpression argExpression = (KtExpression)CollectionsKt.first((Iterable)resolvedCall2.getArgumentMapping().keySet());
            this.raiseIssueIfUselessCheck(kfc, argExpression, callExpression, false, arg_0 -> UselessNullCheckCheck.visitCallExpression$lambda$8(resolvedCall2, arg_0));
        }
    }

    private final KtExpression operandComparedToNull(KtBinaryExpression $this$operandComparedToNull) {
        KtExpression ktExpression = $this$operandComparedToNull.getLeft();
        if (ktExpression == null || (ktExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression, null, 1, null)) == null) {
            return null;
        }
        KtExpression leftResolved = ktExpression;
        KtExpression ktExpression2 = $this$operandComparedToNull.getRight();
        if (ktExpression2 == null || (ktExpression2 = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression2, null, 1, null)) == null) {
            return null;
        }
        KtExpression rightResolved = ktExpression2;
        return PsiUtilsKt.isNull(leftResolved) ? $this$operandComparedToNull.getRight() : (PsiUtilsKt.isNull(rightResolved) ? $this$operandComparedToNull.getLeft() : null);
    }

    private final void raiseIssueIfUselessCheck(KotlinFileContext kfc, KtExpression expression, PsiElement issueLocation, boolean comparesToNull, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        String string2;
        KtExpression resolvedExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(expression, null, 1, null);
        if (PsiUtilsKt.isNull(resolvedExpression)) {
            string2 = comparesToNull ? "succeeds" : "fails";
        } else if (UselessNullCheckCheckKt.access$isNotNullable(expression)) {
            string2 = comparesToNull ? "fails" : "succeeds";
        } else {
            return;
        }
        String result2 = string2;
        AbstractCheck.reportIssue$default((AbstractCheck)this, kfc, issueLocation, null, null, arg_0 -> UselessNullCheckCheck.raiseIssueIfUselessCheck$lambda$9(nullCheckTypeForMessage, result2, arg_0), 6, null);
    }

    private static final Unit visitBinaryExpression$lambda$1$lambda$0(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("null check");
        return Unit.INSTANCE;
    }

    private static final Unit visitBinaryExpression$lambda$3$lambda$2(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("non-null check");
        return Unit.INSTANCE;
    }

    private static final Unit visitBinaryExpression$lambda$4(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("elvis operation ");
        $this$raiseIssueIfUselessCheck.code("?:");
        return Unit.INSTANCE;
    }

    private static final Unit visitSafeQualifiedExpression$lambda$5(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("null-safe access ");
        $this$raiseIssueIfUselessCheck.code("?.");
        return Unit.INSTANCE;
    }

    private static final Unit visitUnaryExpression$lambda$6(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("non-null assertion ");
        $this$raiseIssueIfUselessCheck.code("!!");
        return Unit.INSTANCE;
    }

    private static final Unit visitCallExpression$lambda$8(KaFunctionCall $resolvedCall, Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("non-null check ");
        $this$raiseIssueIfUselessCheck.code(String.valueOf(KaSymbolKt.getName((KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol($resolvedCall.getPartiallyAppliedSymbol()))));
        return Unit.INSTANCE;
    }

    private static final Unit raiseIssueIfUselessCheck$lambda$9(Function1 $nullCheckTypeForMessage, String $result, Message $this$reportIssue) {
        Intrinsics.checkNotNullParameter($this$reportIssue, "$this$reportIssue");
        $this$reportIssue.unaryPlus("Remove this useless ");
        $nullCheckTypeForMessage.invoke($this$reportIssue);
        $this$reportIssue.unaryPlus(", it always " + $result + ".");
        return Unit.INSTANCE;
    }
}

